<?php

/**
 * Class LoadObjects
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Sso\Webservices\ObjectBundle\Entity\Object;

/**
 * Class LoadObjects
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\DataFixtures\ORM\ServiceProvider
 */
class LoadObjects extends AbstractFixture implements OrderedFixtureInterface
{

    /**
     * {@inheritDoc}
     */
    public function load(ObjectManager $manager)
    {
        $rows = [
            ['16FA40FD-5F4B-4937-F53E-F598471AAFD8', 'UnitTestReferenceId001', 'BB25734E-BFF8-878A-E4F7-B2F0F38142F7', 'UnitTestObject1', true],
            ['DF04AF16-5F4B-F53E-4937-F598471AAFD8', 'UnitTestReferenceId002', 'BB25734E-BFF8-878A-E4F7-B2F0F38142F7', 'UnitTestObject2', true],
        ];

        foreach ($rows as $row) {

            $typeEntity = $manager->getRepository('SsoWebservicesObjectBundle:Type')->find($row[2]);

            $entity = new Object();
            $entity->setActive($row[4]);
            $entity->setType($typeEntity);
            $entity->setName($row[3]);
            $entity->setReferenceId($row[1]);

            $manager->persist($entity);

            $entity->setGuid($row[0]);
        }

        $manager->flush();
    }

    /**
     * {@inheritDoc}
     */
    public function getOrder()
    {
        return 2;
    }

}
