<?php

/**
 * Class Index
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Database\Data\TypeMapping;

use Doctrine\Bundle\DoctrineBundle\Registry as DoctrineRegistry;
use Doctrine\ORM\EntityManager;
use Sso\Webservices\ObjectBundle\Entity\TypeMapping as EntityTypeMapping;
use Sso\Webservices\ObjectBundle\Database\Repository\Factory as RepositoryFactory;

/**
 * Class Index
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Database\Data\TypeMapping
 */
class Index
{

    /**
     * Doctrine Registry
     * 
     * @var DoctrineRegistry
     */
    protected $doctrineRegistry;

    /**
     * @var EntityManager
     */
    protected $entityManager;

    /**
     * @var RepositoryFactory
     */
    protected $repositoryFactory;

    /**
     * @param DoctrineRegistry $doctrineRegistry
     * @param RepositoryFactory $repoFactory
     */
    public function __construct(DoctrineRegistry $doctrineRegistry, RepositoryFactory $repoFactory)
    {
        $this->doctrineRegistry = $doctrineRegistry;
        $this->entityManager = $this->doctrineRegistry->getManager('Webservice');
        $this->repositoryFactory = $repoFactory;
    }

    /**
     * @param EntityTypeMapping $entity
     */
    public function save(EntityTypeMapping $entity)
    {
        $this->entityManager->persist($entity);
        $this->entityManager->flush($entity);
    }

    /**
     * @param EntityTypeMapping $entity
     */
    public function delete(EntityTypeMapping $entity)
    {
        $this->entityManager->remove($entity);
        $this->entityManager->flush($entity);
    }

}
