<?php

/**
 * Class Manager
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Database;

use Sso\Webservices\ObjectBundle\Database\Entity;
use Sso\Webservices\ObjectBundle\Database\Repository;
use Sso\Webservices\ObjectBundle\Database\Data;
use Symfony\Component\Validator\Validator\RecursiveValidator as Validator;
use Doctrine\Bundle\DoctrineBundle\Registry as DoctrineRegistry;
use Doctrine\ORM\EntityManager;

/**
 * Database Manager
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Database
 */
class Manager
{

    /**
     * @var array
     */
    protected $manSetter = array();

    /**
     * Doctrine Registry
     *
     * @var DoctrineRegistry
     */
    protected $doctrineRegistry;

    /**
     * @var EntityManager
     */
    protected $entityManager;

    /**
     * Validator
     *
     * @var Validator
     */
    protected $validator;


    /**
     *
     * @param DoctrineRegistry $doctrineRegistry
     * @param Validator $validator
     */
    public function __construct(DoctrineRegistry $doctrineRegistry, Validator $validator)
    {
        $this->doctrineRegistry = $doctrineRegistry;
        $this->validator = $validator;
        $this->entityManager = $this->doctrineRegistry->getManager('Webservice');
    }

    /**
     *
     * @return Repository\Factory
     */
    public function respository()
    {
        if (!isset($this->manSetter['respository'])) {
            $this->manSetter['respository'] = new Repository\Factory($this->entityManager);
        }
        return $this->manSetter['respository'];
    }

    /**
     *
     * @return Entity\Factory
     */
    public function entity()
    {
        if (!isset($this->manSetter['entity'])) {
            $this->manSetter['entity'] = new Entity\Factory();
        }
        return $this->manSetter['entity'];
    }

    /**
     *
     * @return Data\Factory
     */
    public function data()
    {
        if (!isset($this->manSetter['data'])) {
            $this->manSetter['data'] = new Data\Factory($this->doctrineRegistry, $this->respository());
        }
        return $this->manSetter['data'];
    }

    /**
     * connection Webservice
     *
     * @return EntityManager
     */
    public function entityManager()
    {
        return $this->entityManager;
    }

}
