<?php

/**
 *
 * @class Factory
 * @author sb
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 *
 */

namespace Sso\Webservices\ObjectBundle\Database\Repository;

use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityRepository;

class Factory
{

    /**
     *
     * @var array
     */
    protected $facSetter;

    /**
     * @var EntityManager
     */
    protected $entityManager;

    /**
     *
     * @param DoctrineRegistry $doctrineRegistry
     * @param Validator $validator
     */
    public function __construct(EntityManager $entityManager)
    {
        $this->entityManager = $entityManager;
    }

    /**
     *
     * @return EntityRepository
     */
    public function attributeGroup()
    {
        if(!isset($this->facSetter['attributeGroup'])){
            $this->facSetter['attributeGroup'] = $this->entityManager->getRepository('Sso\Webservices\ObjectBundle\Entity\AttributeGroup','Webservice');
        }
        return $this->facSetter['attributeGroup'];
    }

    /**
     *
     * @return EntityRepository
     */
    public function attribute()
    {
        if(!isset($this->facSetter['attribute'])){
            $this->facSetter['attribute'] = $this->entityManager->getRepository('Sso\Webservices\ObjectBundle\Entity\Attribute','Webservice');
        }
        return $this->facSetter['attribute'];
    }

    /**
     *
     * @return EntityRepository
     */
    public function language()
    {
        if(!isset($this->facSetter['language'])){
            $this->facSetter['language'] = $this->entityManager->getRepository('Sso\Webservices\ObjectBundle\Entity\Language','Webservice');
        }
        return $this->facSetter['language'];
    }

    /**
     *
     * @return EntityRepository
     */
    public function object()
    {
        if (!isset($this->facSetter['object'])) {
            $this->facSetter['object'] = $this->entityManager->getRepository('Sso\Webservices\ObjectBundle\Entity\Object','Webservice');
        }
        return $this->facSetter['object'];
    }

    /**
     *
     * @return EntityRepository
     */
    public function objectAttributeValue()
    {
        if (!isset($this->facSetter['objectAttributeValue'])) {
            $this->facSetter['objectAttributeValue'] = $this->entityManager->getRepository('Sso\Webservices\ObjectBundle\Entity\ObjectAttributeValue','Webservice');
        }
        return $this->facSetter['objectAttributeValue'];
    }

    /**
     *
     * @return EntityRepository
     */
    public function type()
    {
        if (!isset($this->facSetter['type'])) {
            $this->facSetter['type'] = $this->entityManager->getRepository('Sso\Webservices\ObjectBundle\Entity\Type','Webservice');
        }
        return $this->facSetter['type'];
    }

    /**
     *
     * @return EntityRepository
     */
    public function typeMapping()
    {
        if (!isset($this->facSetter['typeMapping'])) {
            $this->facSetter['typeMapping'] = $this->entityManager->getRepository('Sso\Webservices\ObjectBundle\Entity\TypeMapping','Webservice');
        }
        return $this->facSetter['typeMapping'];
    }

}
