<?php

namespace Sso\Webservices\ObjectBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Ramsey\Uuid\Uuid;

/**
 * @ORM\Entity
 * @ORM\Table(name="obj_attribute")
 * @ORM\HasLifecycleCallbacks()
 */
class Attribute
{
    /**
     * @var string
     *
     * @ORM\Column(name="id", type="uuid", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255, nullable=false)
     */
    private $name;

    /**
     * @var string
     *
     * @ORM\Column(name="lower_name", type="string", length=255, nullable=false)
     */
    private $lowerName;

    /**
     * @var AttributeGroup
     *
     * @ORM\ManyToOne(targetEntity="AttributeGroup", inversedBy="attributes")
     * @ORM\JoinColumn(name="attribute_group_id", referencedColumnName="id", nullable=false)
     */
    private $attributeGroup;

    /**
     * @var ObjectAttributeValue[]
     *
     * @ORM\OneToMany(targetEntity="ObjectAttributeValue", mappedBy="attribute")
     */
    private $attributeValues;

    /**
     * @var bool
     *
     * @ORM\Column(name="mandatory", type="boolean", options={"default"=0})
     */
    private $mandatory = false;

    /**
     * @var mixed
     *
     * @ORM\Column(name="possible_values", type="array", nullable=true)
     */
    private $possibleValues;

    /**
     * @var string
     *
     * @ORM\Column(name="default_value", type="string", length=255, nullable=true)
     */
    private $defaultValue;

    /**
     * @var bool
     *
     * @ORM\Column(name="translatable", type="boolean", options={"default"=0})
     */
    private $translatable = false;

    /**
     * @var \DateTime
     * 
     * @ORM\Column(name="created", type="datetime", nullable=false)
     */
    private $created;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="updated", type="datetime", nullable=false)
     */
    private $updated;

    public function __construct()
    {
        $this->id = Uuid::uuid4();
        $this->attributeValues = new ArrayCollection();
    }

    /**
     * Set id
     *
     * @param string $id
     * @return Attribute
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get id
     *
     * @return string
     */
    public function getId()
    {
        return (string)$this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Attribute
     */
    public function setName($name)
    {
        $this->name = $name;
        $this->setLowerName(mb_strtolower($name, 'utf-8'));

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set lowerName
     *
     * @param string $lowerName
     * @return Attribute
     */
    public function setLowerName($lowerName)
    {
        $this->lowerName = $lowerName;

        return $this;
    }

    /**
     * Get lowerName
     *
     * @return string
     */
    public function getLowerName()
    {
        return $this->lowerName;
    }

    /**
     * Set attributeGroup
     *
     * @param \Sso\Webservices\ObjectBundle\Entity\AttributeGroup $attributeGroup
     * @return Attribute
     */
    public function setAttributeGroup(\Sso\Webservices\ObjectBundle\Entity\AttributeGroup $attributeGroup)
    {
        $this->attributeGroup = $attributeGroup;

        return $this;
    }

    /**
     * Get attributeGroup
     *
     * @return \Sso\Webservices\ObjectBundle\Entity\AttributeGroup
     */
    public function getAttributeGroup()
    {
        return $this->attributeGroup;
    }

    /**
     * Add attributeValues
     *
     * @param \Sso\Webservices\ObjectBundle\Entity\ObjectAttributeValue $attributeValues
     * @return Attribute
     */
    public function addAttributeValue(\Sso\Webservices\ObjectBundle\Entity\ObjectAttributeValue $attributeValues)
    {
        $this->attributeValues[] = $attributeValues;

        return $this;
    }

    /**
     * Remove attributeValues
     *
     * @param \Sso\Webservices\ObjectBundle\Entity\ObjectAttributeValue $attributeValues
     */
    public function removeAttributeValue(\Sso\Webservices\ObjectBundle\Entity\ObjectAttributeValue $attributeValues)
    {
        $this->attributeValues->removeElement($attributeValues);
    }

    /**
     * Get attributeValues
     *
     * @return ObjectAttributeValue[]
     */
    public function getAttributeValues()
    {
        return $this->attributeValues;
    }

    /**
     * @return bool
     */
    public function getMandatory()
    {
        return $this->mandatory;
    }

    /**
     * @param bool $mandatory
     * @return Attribute
     */
    public function setMandatory($mandatory)
    {
        $this->mandatory = $mandatory;

        return $this;
    }

    /**
     * @return array
     */
    public function getPossibleValues()
    {
        return $this->possibleValues;
    }

    /**
     * @param array $possibleValues
     * @return Attribute
     */
    public function setPossibleValues($possibleValues)
    {
        $this->possibleValues = $possibleValues;

        return $this;
    }

    /**
     * @return string
     */
    public function getDefaultValue()
    {
        return $this->defaultValue;
    }

    /**
     * @param string $defaultValue
     * @return Attribute
     */
    public function setDefaultValue($defaultValue)
    {
        if(!empty($this->possibleValues) && !in_array($defaultValue, $this->possibleValues)){
            throw new \InvalidArgumentException('Default value should be one of the possible values (' . implode(', ', $this->possibleValues) . ')');
        }

        $this->defaultValue = $defaultValue;

        return $this;
    }

    /**
     * @return bool
     */
    public function getTranslatable()
    {
        return $this->translatable;
    }

    /**
     * @param bool $translatable
     * @return Attribute
     */
    public function setTranslatable($translatable)
    {
        $this->translatable = $translatable;

        return $this;
    }

    /**
     * Set created
     *
     * @ORM\PrePersist
     */
    public function setCreatedAt()
    {
        $this->created = new \DateTime();
        $this->updated = new \DateTime();
    }

    /**
     * Get created
     *
     * @return \DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * Set updated
     *
     * @ORM\PreUpdate
     */
    public function setUpdated()
    {
        $this->updated = new \DateTime();
    }

    /**
     * Get updated
     *
     * @return \DateTime
     */
    public function getUpdated()
    {
        return $this->updated;
    }
}
