<?php

namespace Sso\Webservices\ObjectBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Sso\Webservices\ObjectBundle\Entity\Object as EntityObj;
use Ramsey\Uuid\Uuid;

/**
 * @ORM\Entity
 * @ORM\Table(name="obj_type",indexes={@Orm\Index(name="name_idx", columns={"name"})})
 * @ORM\HasLifecycleCallbacks()
 */
class Type
{

    /**
     * @var string
     *
     * @ORM\Column(name="id", type="uuid", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $id;

    /**
     *
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255, nullable=false)
     */
    private $name;

    /**
     *
     * @var string
     *
     * @ORM\Column(name="lower_name", type="string", length=255, nullable=false)
     */
    private $lowerName;

    /**
     *
     * @var integer
     *
     * @ORM\Column(name="type_order", type="integer", nullable=true, options={"unsigned":true})
     */
    private $typeOrder;

    /**
     *
     * ORM Mapping
     * @ORM\Column(name="created", type="datetime", nullable=false)
     *
     * Define Var Type
     * @var \DateTime
     *
     */
    private $created;

    /**
     *
     * ORM Mapping
     * @ORM\Column(name="updated", type="datetime", nullable=false)
     *
     * Define Var Type
     * @var \DateTime
     *
     */
    private $updated;

    /**
     * @var AttributeGroup[]
     *
     * @ORM\ManyToMany(targetEntity="AttributeGroup", mappedBy="types")
     */
    private $attributeGroups;

    /**
     * @ORM\OneToMany(targetEntity="Object", mappedBy="type")
     *
     * @var Object[]
     */
    private $objects;

    /**
     * @var TypeMapping
     *
     * @ORM\OneToOne(targetEntity="TypeMapping", mappedBy="type")
     */
    private $typeMapping;

    public function __construct()
    {
        $this->id = Uuid::uuid4();
        $this->attributeGroups = new ArrayCollection();
        $this->objects = new ArrayCollection();
    }

    /**
     * Set id
     *
     * @param string $id
     * @return Type
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get id
     *
     * @return string
     */
    public function getId()
    {
        return (string)$this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Type
     */
    public function setName($name)
    {
        $this->name = $name;
        $this->setLowerName(mb_strtolower($name, 'utf-8'));
        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set lowerName
     *
     * @param string $lowerName
     * @return Type
     */
    public function setLowerName($lowerName)
    {
        $this->lowerName = $lowerName;

        return $this;
    }

    /**
     * Get lowerName
     *
     * @return string
     */
    public function getLowerName()
    {
        return $this->lowerName;
    }

    /**
     * Set order
     *
     * @param integer $typeOrder
     * @return Type
     */
    public function setTypeOrder($typeOrder)
    {
        $this->typeOrder = $typeOrder;

        return $this;
    }

    /**
     * Get typeOrder
     *
     * @return integer
     */
    public function getTypeOrder()
    {
        return $this->typeOrder;
    }

    /**
     * Set created
     *
     * @ORM\PrePersist
     */
    public function setCreatedAt()
    {
        $this->created = new \DateTime();
        $this->updated = new \DateTime();
    }

    /**
     * Get created
     *
     * @return \DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * Set updated
     *
     * @ORM\PreUpdate
     */
    public function setUpdated()
    {
        $this->updated = new \DateTime();
    }

    /**
     * Get updated
     *
     * @return \DateTime
     */
    public function getUpdated()
    {
        return $this->updated;
    }

    /**
     * Get attributeGroups
     *
     * @return AttributeGroup[]
     */
    public function getAttributeGroups()
    {
        return $this->attributeGroups;
    }

    /**
     * Get attributeGroups
     *
     * @return Object[]
     */
    public function getObjects()
    {
        return $this->objects;
    }

    /**
     * @return TypeMapping
     */
    public function getTypeMapping()
    {
        return $this->typeMapping;
    }

}
