<?php

namespace Sso\Webservices\ObjectBundle\Model\Request\AttributeGroup\Add\Entity;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * @Serializer\XmlRoot("AttributeGroupType")
 * @Serializer\ExclusionPolicy("all")
 */
class AttributeGroup
{

    /**
     * @Assert\NotBlank(message = "attributeGroupAdd00##Invalid AttributeGroup Name##AttributeGroup Name should not be empty",)
     *
     * @Assert\Length(
     *      min = 3,
     *      max = 200,
     *      minMessage = "attributeGroupAdd01##Invalid AttributeGroup Name##AttributeGroup Name must be at least {{ limit }} characters long",
     *      maxMessage = "attributeGroupAdd##Invalid AttributeGroup Name##AttributeGroup Name cannot be longer than {{ limit }} characters",
     *      exactMessage = "attributeGroupAdd01##Invalid AttributeGroup Name##AttributeGroup Name should have exactly {{ limit }} characters"
     * )
     * 
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Name")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("Types")
     * @Serializer\Type("ArrayCollection<Sso\Webservices\ObjectBundle\Model\Request\AttributeGroup\Add\Entity\Type>")
     * @Serializer\XmlList(entry="Type")
     */
    private $type;

    public function __construct()
    {
        $this->type = new ArrayCollection();
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get name
     *
     * @return array 
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param Type $type
     * @return AttributeGroup
     */
    public function addType(Type $type)
    {
        $this->type[] = $type;

        return $this;
    }

}
