<?php

namespace Sso\Webservices\ObjectBundle\Model\Request\AttributeGroup\Add\Entity;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @Serializer\XmlRoot("Type")
 * @Serializer\ExclusionPolicy("all")
 */
class Type
{

    /**
     * @Assert\NotBlank(message = "attributeGroupAdd03##Invalid TypeId##TypeId should not be empty",)
     *
     * @Assert\Length(
     *      min = 36,
     *      max = 36,
     *      minMessage = "attributeAdd00##Invalid Id##Id must be at least {{ limit }} characters long",
     *      maxMessage = "attributeAdd00##Invalid Id##Id cannot be longer than {{ limit }} characters",
     *      exactMessage = "attributeAdd00##Invalid Id##Id should have exactly {{ limit }} characters"
     * )
     *
     * @Serializer\SerializedName("Id")
     * @Serializer\Expose
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $id;

    /**
     * Get name
     *
     * @return string 
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getId()
    {
        return $this->id;
    }

}
