<?php

/**
 * Class AttributeGroup
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Request\AttributeGroup\Update;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class AttributeGroup
 *
 * @Serializer\XmlRoot("AttributeGroupType")
 * @Serializer\ExclusionPolicy("all")
 *
 * @package Sso\Webservices\ObjectBundle\Model\Request\AttributeGroup\Update
 */
class AttributeGroup
{

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Id")
     *
     * @Assert\NotBlank(message = "attributeGroupUpdate01##Invalid AttributeGroup ID##AttributeGroup Id should not be empty",)
     * @Assert\Length(
     *      min = 36,
     *      max = 36,
     *      minMessage = "attributeGroupUpdate01##Invalid AttributeGroup ID##Your AttributeGroup Id must be {{ limit }} characters long",
     *      maxMessage = "attributeGroupUpdate01##Invalid AttributeGroup ID##Your AttributeGroup Id must be {{ limit }} characters long",
     *      exactMessage = "attributeGroupUpdate01##Invalid AttributeGroup ID##Your AttributeGroup Id must be {{ limit }} characters long"
     * )
     *
     * @var string
     */
    private $id;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Name")
     *
     * @Assert\Length(
     *      min = 3,
     *      max = 200,
     *      minMessage = "attributeGroupUpdate02##Invalid AttributeGroup Name##AttributeGroup Name must be at least {{ limit }} characters long",
     *      maxMessage = "attributeGroupUpdate02##Invalid AttributeGroup Name##AttributeGroup Name cannot be longer than {{ limit }} characters",
     *      exactMessage = "attributeGroupUpdate02##Invalid AttributeGroup Name##AttributeGroup Name should have exactly {{ limit }} characters"
     * )
     * 
     * @var string
     */
    private $name;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("AddTypes")
     * @Serializer\Type("ArrayCollection<Sso\Webservices\ObjectBundle\Model\Request\AttributeGroup\Update\AddType>")
     * @Serializer\XmlList(entry="TypeId")
     *
     * @var ArrayCollection
     */
    private $addTypes;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("DeleteTypes")
     * @Serializer\Type("ArrayCollection<Sso\Webservices\ObjectBundle\Model\Request\AttributeGroup\Update\DeleteType>")
     * @Serializer\XmlList(entry="TypeId")
     *
     * @var ArrayCollection
     */
    private $deleteTypes;

    /**
     * @Serializer\Expose
     * @Serializer\Type("boolean")
     * @Serializer\SerializedName("DeleteReferences")
     *
     * @var bool
     */
    private $deleteReferences = false;

    public function __construct()
    {
        $this->addTypes = new ArrayCollection();
        $this->deleteTypes = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param string $id
     * @return AttributeGroup
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get name
     *
     * @param $name
     * @return string
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get name
     *
     * @return AddType[]
     */
    public function getAddTypes()
    {
        return $this->addTypes;
    }

    /**
     * @param AddType $type
     * @return AttributeGroup
     */
    public function addAddType(AddType $type)
    {
        $this->addTypes[] = $type;

        return $this;
    }

    /**
     * @return DeleteType[]
     */
    public function getDeleteTypes()
    {
        return $this->deleteTypes;
    }

    /**
     * @param DeleteType $type
     * @return AttributeGroup
     */
    public function addDeleteTypes(DeleteType $type)
    {
        $this->deleteTypes[] = $type;

        return $this;
    }

    /**
     * @return boolean
     */
    public function isDeleteReferences()
    {
        return $this->deleteReferences ? true : false;
    }

    /**
     * @param boolean $deleteReferences
     * @return AttributeGroup
     */
    public function setDeleteReferences($deleteReferences)
    {
        $this->deleteReferences = (boolean) $deleteReferences;

        return $this;
    }

}
