<?php

/**
 * Request object factory
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Request\Object;

use Sso\ApiBundle\Api\Manager as ApiManager;

/**
 * Request object factory
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class Factory
{

    /**
     * Api Manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }


    /**
     * Get wordlets factory
     *
     * @param \SimpleXMLElement $simpleXML
     * @return Add\Add
     */
    public function add(\SimpleXMLElement $simpleXML)
    {
        $model = new Add\Add($this->apiM);
        $model->init($simpleXML);

        return $model;
    }

    /**
     * Get ShowSingle\Show
     *
     * @param \SimpleXMLElement $simpleXML
     * @return ShowSingle\Show
     */
    public function showSingle(\SimpleXMLElement $simpleXML)
    {
        $model = new ShowSingle\Show($this->apiM);
        $model->init($simpleXML);

        return $model;
    }

    /**
     * Get ShowMulti\Show
     *
     * @param \SimpleXMLElement $simpleXML
     * @return ShowMulti\Show
     */
    public function showMulti(\SimpleXMLElement $simpleXML)
    {
        $model = new ShowMulti\Show($this->apiM);
        $model->init($simpleXML);

        return $model;
    }

    /**
     * Get TreeView\Show
     *
     * @param \SimpleXMLElement $simpleXML
     * @return TreeView\Show
     */
    public function treeView(\SimpleXMLElement $simpleXML)
    {
        $model = new TreeView\Show($this->apiM);
        $model->init($simpleXML);

        return $model;
    }

    /**
     * Update factory
     *
     * @param \SimpleXMLElement $simpleXML
     * @return Update\Update
     */
    public function update(\SimpleXMLElement $simpleXML)
    {
        $model = new Update\Update($this->apiM);
        $model->init($simpleXML);

        return $model;
    }

    /**
     * Delete factory
     *
     * @param \SimpleXMLElement $simpleXML
     * @return Delete\Delete
     */
    public function delete(\SimpleXMLElement $simpleXML)
    {
        $model = new Delete\Delete($this->apiM);
        $model->init($simpleXML);

        return $model;
    }

}
