<?php

/**
 * Class Entity
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Request\Object\ShowSingle;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;
use Sso\Webservices\ObjectBundle\Entity\TypeMapping as EntityTypeMapping;

/**
 * Class Entity
 *
 * @Serializer\XmlRoot("ObjectType")
 * @Serializer\ExclusionPolicy("all")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Model\Request\Object\ShowSingle
 */
class Entity
{

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Guid")
     *
     * @Assert\Length(
     *     min = 36,
     *     max = 36,
     *     minMessage = "objectShowSingle01##Invalid guid##Your guid must be {{ limit }} characters long",
     *     maxMessage = "objectShowSingle01##Invalid guid##Your guid must be {{ limit }} characters long",
     *     exactMessage = "objectShowSingle01##Invalid guid##Your guid must be {{ limit }} characters long"
     * )
     *
     * @var string
     */
    private $guid;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("ReferenceId")
     *
     * @Assert\Length(
     *     min = 1,
     *     max = 255,
     *     minMessage = "objectShowSingle02##Invalid reference id##Your reference id must be {{ limit }} characters long",
     *     maxMessage = "objectShowSingle02##Invalid reference id##Your reference id must be {{ limit }} characters long"
     * )
     *
     * @var string
     */
    private $referenceId;

    /**
     * @Serializer\Expose
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("Offset")
     *
     * @Assert\Type(
     *    type="integer",
     *    message="objectShowSingle03##Invalid offset##Your offset {{ value }} is not a valid {{ type }}."
     * )
     * @Assert\GreaterThanOrEqual(
     *     value = 0,
     *     message = "objectShowSingle04##Invalid offset##Your offset must be greater than or equal {{ compared_value }}"
     * )
     *
     * @var string
     */
    private $offset;

    /**
     * @Serializer\Expose
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("Limit")
     *
     * @Assert\Range(
     *      min = 1,
     *      max = 1500,
     *      minMessage = "objectShowSingle05##Invalid limit##Your limit must be at least {{ limit }}.",
     *      maxMessage = "objectShowSingle05##Invalid limit##Your limit can not be bigger than {{ limit }}."
     * )
     *
     * @var string
     */
    private $limit;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("LanguageCode")
     *
     * @Assert\Length(
     *      min = 2,
     *      max = 3,
     *      minMessage = "objectShowSingle06##Invalid language code##Your language code must be at least {{ limit }}.",
     *      maxMessage = "objectShowSingle06##Invalid language code##Your language code can not be bigger than {{ limit }}."
     * )
     *
     * @var string
     */
    private $languageCode;

    /**
     * Set $guid
     *
     * @param string $guid
     * @return Entity
     */
    public function setGuid($guid)
    {
        $this->guid = $guid;

        return $this;
    }

    /**
     * Get $guid
     *
     * @return string
     */
    public function getGuid()
    {
        return $this->guid;
    }

    /**
     * @return string
     */
    public function getReferenceId()
    {
        return $this->referenceId;
    }

    /**
     * @param string $referenceId
     * @return Entity
     */
    public function setReferenceId($referenceId)
    {
        $this->referenceId = $referenceId;

        return $this;
    }

    /**
     * @return string
     */
    public function getOffset()
    {
        return $this->offset;
    }

    /**
     * @param string $offset
     * @return Entity
     */
    public function setOffset($offset)
    {
        $this->offset = $offset;

        return $this;
    }

    /**
     * @return string
     */
    public function getLimit()
    {
        return $this->limit;
    }

    /**
     * @param string $limit
     * @return Entity
     */
    public function setLimit($limit)
    {
        $this->limit = $limit;

        return $this;
    }

    /**
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->languageCode;
    }

    /**
     * @param string $languageCode
     * @return Entity
     */
    public function setLanguageCode($languageCode)
    {
        $this->languageCode = $languageCode;

        return $this;
    }

}
