<?php

namespace Sso\Webservices\ObjectBundle\Model\Request\ObjectValue\Add\Entity;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @Serializer\XmlRoot("ObjectValueType")
 * @Serializer\ExclusionPolicy("all")
 */
class ObjectValue
{
    /**
     * Validation
     * 
     * @Assert\NotBlank(message = "objectValueAdd00##Invalid ObjectGuid##ObjectGuid should not be empty")
     *
     * @Assert\Length(
     *      min = 36,
     *      max = 36,
     *      minMessage = "objectValueAdd01##Invalid ObjectGuid##ObjectGuid must be at least {{ limit }} characters long",
     *      maxMessage = "objectValueAdd01##Invalid ObjectGuid##ObjectGuid cannot be longer than {{ limit }} characters",
     *      exactMessage = "objectValueAdd01##Invalid ObjectGuid##ObjectGuid should have exactly {{ limit }} characters"
     * )
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("ObjectGuid")
     * 
     * @var string
     */
    private $objectGuid;

    /**
     * Validation
     * 
     * @Assert\NotBlank(message = "objectValueAdd00##Invalid ObjectValue##ObjectValue should not be empty")
     * 
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("ObjectValue")
     * 
     * @var string
     */
    private $objectValue;

    /**
     * @Assert\NotBlank(message = "objectValueAdd00##Invalid LanguageCode##LanguageCode should not be empty")
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("LanguageCode")
     *
     * @var string
     */
    private $languageCode;

    /**
     * @Assert\NotBlank(message = "objectValueAdd00##Invalid AttributeId##AttributeId should not be empty")
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("AttributeId")
     *
     * @var string
     */
    private $attributeId;

    /**
     * @return string
     */
    public function getObjectGuid()
    {
        return $this->objectGuid;
    }

    /**
     * @return string
     */
    public function getObjectValue()
    {
        return $this->objectValue;
    }

    /**
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->languageCode;
    }

    /**
     * @return string
     */
    public function getAttributeId()
    {
        return $this->attributeId;
    }

    /**
     * @param string $objectGuid
     */
    public function setObjectGuid($objectGuid)
    {
        $this->objectGuid = $objectGuid;
    }

    /**
     * @param string $objectValue
     */
    public function setObjectValue($objectValue)
    {
        $this->objectValue = $objectValue;
    }

    /**
     * @param string $languageCode
     */
    public function setLanguageCode($languageCode)
    {
        $this->languageCode = $languageCode;
    }

    /**
     * @param string $attributeId
     */
    public function setAttributeId($attributeId)
    {
        $this->attributeId = $attributeId;
    }
}
