<?php

/**
 * 
 * @class Show
 * @author sb
 * 
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 * 
 */

namespace Sso\Webservices\ObjectBundle\Model\Request\Type\Show;

use LifeStyle\Tools\WebserviceBundle\Error\Type\External as ExternalError;
use LifeStyle\Tools\WebserviceBundle\Validator\Xml as XmlValidator;
use LifeStyle\Tools\WebserviceBundle\Exception\InvalidRecordException;
use Sso\ApiBundle\Api\Manager as ApiManager;
use Sso\Webservices\ObjectBundle\Entity\Type as EntityType;

/**
 * type add request model
 */
class Show
{

    /**
     *
     * @var Manager\Index
     */
    protected $apiM;

    
    /**
     *
     * @var \Sso\Webservices\ObjectBundle\Model\Request\Type\Show\Entity
     */
    protected $helperModel;
    
    /**
     *
     * @var EntityType[] 
     */
    protected $typeModels;


    /**
     * 
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * Returns a xml-string with allowed structure
     * 
     * @return string
     */
    protected function _xmlAllowedElements()
    {
        return '<TypeType required="true">'
                . '<Name/>'
                . '<Id/>'
                . '</TypeType>';
    }

    /**
     * Init model
     * 
     * @param \SimpleXMLElement $simpleXML
     */
    public function init(\SimpleXMLElement $simpleXML)
    {
        $validator = new XmlValidator();
        if (!$validator->validate($simpleXML, $validator->strToXml($this->_xmlAllowedElements()))) {
            $this->apiM->errors()->addErrors($validator->errors()->getErrors());
            throw new InvalidRecordException('Invalid xml elements.');
        }
        
        // set helper model
        $this->helperModel = $this->apiM->serializer()->deserialize($simpleXML->TypeType->saveXML(), 'Sso\Webservices\ObjectBundle\Model\Request\Type\Show\Entity', 'xml');

        $this->getTypeEntities();
    }

    /**
     * 
     */
    public function getTypeEntities()
    {
        $typeRepos = $this->apiM->database()->webservice()->types()->getTypeRepository();
        
        // data
        $id = $this->helperModel->getId();
        $name = $this->helperModel->getName();
        $search = array();
        
        if($id){
            $search = ["id" => $id];
            $this->typeModels = $typeRepos->findBy($search);
            return;
        }
        
        if($name){
            $search = ["name" => $name];
            $this->typeModels = $typeRepos->findBy($search);
            return;
        }
        
        $this->typeModels = $typeRepos->findAll();
    }

    /**
     * 
     * @return EntityType[]
     */
    public function getTypeModels()
    {
        return $this->typeModels;
    }

}
