<?php

/**
 * Class Add
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Response\Attribute\Add;

use Sso\Webservices\ObjectBundle\Model\Response\AttributeGroup\Base as AttributeGroupBase;
use Sso\Webservices\ObjectBundle\Model\Response\Attribute\Add\Entity\Attribute as ResponseObject;
use Sso\Webservices\ObjectBundle\Entity\Attribute as EntityAttribute;

/**
 * Class Add
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Model\Response\Attribute\Add
 */
class Add extends AttributeGroupBase
{
    /**
     * @var \DOMElement
     */
    protected $xmlContainer;

    /**
     * @var EntityAttribute
     */
    protected $attributeEntity;

    /**
     * @param EntityAttribute $attributeEntity
     */
    public function init(EntityAttribute $attributeEntity)
    {
        //ok first set the db entity
        $this->attributeEntity = $attributeEntity;
    }

    /**
     * Returns response status
     *
     * @return string|bool
     */
    protected function getResponseStatus()
    {
        return $this->attributeEntity ? 'Success' : 'Failure';
    }

    /**
     * Returns response message
     *
     * @return string
     */
    protected function getResponseMessage()
    {
        return $this->attributeEntity ? false : 'attributeEntity data not found';
    }

    /**
     * Build response body
     *
     * @param \DOMElement $xmlContainer
     */
    protected function buildResponseBody(\DOMElement $xmlContainer)
    {
        parent::buildResponseBody($xmlContainer);
        $this->xmlContainer = $xmlContainer;
        if ($this->attributeEntity) {
            $modelOut = new ResponseObject();
            $modelOut->setId($this->attributeEntity->getId())
                ->setName($this->attributeEntity->getName())
                ->setMandatory($this->attributeEntity->getMandatory())
                ->setPossibleValues($this->attributeEntity->getPossibleValues())
                ->setDefaultValue($this->attributeEntity->getDefaultValue())
                ->setTranslatable($this->attributeEntity->getTranslatable())
                ->setAttributeGroupId($this->attributeEntity->getAttributeGroup()->getId());

            $document = $this->apiM->responseBuilder()->document();
            $docFragment = $document->createDocumentFragment();
            $docFragment->appendXML(
                preg_replace('/^\<?[^\>]*\>\s*/', '', $this->apiM->serializer()->serialize($modelOut, 'xml'))
            );

            $xmlContainer->appendChild($docFragment);
        }
    }
}
