<?php

namespace Sso\Webservices\ObjectBundle\Model\Response\Attribute\Show\Entity;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * @Serializer\XmlRoot("AttributeGroup")
 * @Serializer\ExclusionPolicy("all")
 */
class AttributeGroup
{

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Id")
     *
     * @var string
     */
    private $id;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Name")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("Attributes")
     * @Serializer\Type("array<Sso\Webservices\ObjectBundle\Model\Response\Attribute\Show\Entity\Attribute>")
     * @Serializer\XmlList(entry = "Attribute")
     */
    private $attributes;
    
    
     public function __construct()
    {
        $this->attributes = new ArrayCollection();
    }
    
    /**
     * Get name
     *
     * @return string 
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }
    
     /**
     * Get name
     *
     * @return array 
     */
    public function getAttribute()
    {
        return $this->attributes;
    }

    public function setAttribute($attributes)
    {
        $this->attributes[] = $attributes;

        return $this;
    }

}
