<?php

/**
 * 
 * @class Show
 * @author sb
 * 
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 * 
 */

namespace Sso\Webservices\ObjectBundle\Model\Response\AttributeGroup\Add;

use Sso\Webservices\ObjectBundle\Model\Response\AttributeGroup\Base as AttributeGroupBase;

use Sso\Webservices\ObjectBundle\Model\Response\AttributeGroup\Add\Entity\AttributeGroup as ResponseObject;
use Sso\Webservices\ObjectBundle\Model\Response\AttributeGroup\Add\Entity\Type as ResponseType;
use Sso\Webservices\ObjectBundle\Entity\AttributeGroup as EntityAttributeGroup;

class Add extends AttributeGroupBase
{

    /**
     *
     * @var \DOMElement
     */
    protected $xmlContainer;

    /**
     *
     * @var EntityAttributeGroup
     */
    protected $attributegroupEntity;

    /**
     * 
     * @param EntityAttributeGroup $objectEntity
     */
    public function init(EntityAttributeGroup $attributegroupEntity)
    {
        //ok first set the db entity
        $this->attributegroupEntity = $attributegroupEntity;
    }

    /**
     * Returns response status
     * 
     * @return string|bool
     */
    protected function getResponseStatus()
    {
        return $this->attributegroupEntity ? 'Success' : 'Failure';
    }

    /**
     * Returns response message
     * 
     * @return string
     */
    protected function getResponseMessage()
    {
        return $this->attributegroupEntity ? false : 'attributegroupEntity data not found';
    }

    /**
     * Build response body
     * 
     * @param \DOMElement $xmlContainer
     */
    protected function buildResponseBody(\DOMElement $xmlContainer)
    {
        parent::buildResponseBody($xmlContainer);
        $this->xmlContainer = $xmlContainer;
        if ($this->attributegroupEntity) {
            $modelOut = $this->apiM->mapper()->modelInToModelOut($this->attributegroupEntity, new ResponseObject());
            //now we need to set the types
            foreach ($this->attributegroupEntity->getTypes() as $type) {
                $typeOut = new ResponseType();
                $typeOut->setId($type->getId());
                $modelOut->addType($typeOut);
            }

            $document = $this->apiM->responseBuilder()->document();
            $docFragment = $document->createDocumentFragment();
            $docFragment->appendXML(preg_replace('/^\<?[^\>]*\>\s*/', '', $this->apiM->serializer()->serialize($modelOut, 'xml')));

            $xmlContainer->appendChild($docFragment);
        }
    }

}
