<?php

/**
 * Class Update
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Response\AttributeGroup\Update;

use Sso\Webservices\ObjectBundle\Model\Response\AttributeGroup\Base as AttributeGroupBase;
use Sso\Webservices\ObjectBundle\Model\Response\AttributeGroup\Update\AttributeGroup as ResponseObject;
use Sso\Webservices\ObjectBundle\Entity\AttributeGroup as EntityAttributeGroup;

/**
 * Class Update
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Model\Response\AttributeGroup\Update
 */
class Update extends AttributeGroupBase
{

    /**
     *
     * @var \DOMElement
     */
    protected $xmlContainer;

    /**
     *
     * @var EntityAttributeGroup
     */
    protected $attributeGroupEntity;

    /**
     * @param EntityAttributeGroup $attributeGroupEntity
     */
    public function init(EntityAttributeGroup $attributeGroupEntity)
    {
        $this->attributeGroupEntity = $attributeGroupEntity;
    }

    /**
     * Returns response status
     * 
     * @return string|bool
     */
    protected function getResponseStatus()
    {
        return $this->attributeGroupEntity ? 'Success' : 'Failure';
    }

    /**
     * Returns response message
     * 
     * @return string
     */
    protected function getResponseMessage()
    {
        return $this->attributeGroupEntity ? false : 'attributeGroupEntity data not found';
    }

    /**
     * Build response body
     * 
     * @param \DOMElement $xmlContainer
     */
    protected function buildResponseBody(\DOMElement $xmlContainer)
    {
        parent::buildResponseBody($xmlContainer);
        $this->xmlContainer = $xmlContainer;
        if ($this->attributeGroupEntity) {
            $modelOut = $this->apiM->mapper()->modelInToModelOut($this->attributeGroupEntity, new ResponseObject());
            //now we need to set the types
            foreach ($this->attributeGroupEntity->getTypes() as $type) {
                $typeOut = new Type();
                $typeOut->setId($type->getId());
                $modelOut->addType($typeOut);
            }
            $document = $this->apiM->responseBuilder()->document();
            $docFragment = $document->createDocumentFragment();
            $docFragment->appendXML(preg_replace('/^\<?[^\>]*\>\s*/', '', $this->apiM->serializer()->serialize($modelOut, 'xml')));

            $xmlContainer->appendChild($docFragment);
        }
    }

}
