<?php

/**
 * Class Factory
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Response\Language;

use Sso\Webservices\ObjectBundle\Model\Response\Language\Show;
use Sso\ApiBundle\Api\Manager as ApiManager;
use Sso\Webservices\ObjectBundle\Entity\Language as EntityLanguage;

/**
 * Class Factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Model\Response\Language
 */
class Factory
{
     /**
     * Api Manager
     * 
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     * 
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @param EntityLanguage[] $languageEntities
     * @param int $languagesCount
     */
    public function show($languageEntities, $languagesCount)
    {
        $model = new Show\Show($this->apiM);
        $model->init($languageEntities, $languagesCount);
        $model->createResponse();
    }

}