<?php

/**
 * Class Show
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Response\Language\Show;

use Sso\Webservices\ObjectBundle\Model\Response\Language\Base as TypeBase;
use Sso\Webservices\ObjectBundle\Model\Response\Language\Show\Entity as ResponseLanguage;
use Sso\Webservices\ObjectBundle\Entity\Language as EntityLanguage;
use LifeStyle\Tools\WebserviceBundle\Error\Type\External as ExternalError;

/**
 * Class Show
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Model\Response\Language\Show
 */
class Show extends TypeBase
{

    /**
     * @var \DOMElement
     */
    protected $xmlContainer;

    /**
     * @var EntityLanguage[]
     */
    protected $languageEntities;

    /**
     * @var int
     */
    protected $languagesCount;

    /**
     * @param EntityLanguage[] $languageEntities
     * @param int $languagesCount
     */
    public function init($languageEntities, $languagesCount)
    {
        //ok first set the db entity
        $this->languageEntities = $languageEntities;
        $this->languagesCount = $languagesCount;

    }

    /**
     * Returns response status
     *
     * @return string|bool
     */
    protected function getResponseStatus()
    {
        return $this->languageEntities ? 'Success' : 'Failure';
    }

    /**
     * Returns response message
     *
     * @return string
     */
    protected function getResponseMessage()
    {
        return $this->languageEntities ? false : 'Language not found';
    }

    /**
     * Build response body
     *
     * @param \DOMElement $xmlContainer
     */
    protected function buildResponseBody(\DOMElement $xmlContainer)
    {
        parent::buildResponseBody($xmlContainer);
        $this->xmlContainer = $xmlContainer;

        if ($this->languageEntities) {
            //now we are remap enity
            $this->apiM->responseBuilder()->addCount($this->languagesCount);
            $document = $this->apiM->responseBuilder()->document();

            foreach ($this->languageEntities as $modelIn) {

                $modelOut = $this->apiM->mapper()->modelInToModelOut($modelIn, new Entity());

                $docFragment = $document->createDocumentFragment();
                $docFragment->appendXML(preg_replace('/^\<?[^\>]*\>\s*/', '', $this->apiM->serializer()->serialize($modelOut, 'xml')));

                $xmlContainer->appendChild($docFragment);
            }
        } else {
            $this->apiM->errors()->clearErrors();
            $this->apiM->errors()->addError(new ExternalError('os001', 'No languages found.', 'No languages found.', 'No languages found for given id.'));
        }
    }

}
