<?php

/**
 * 
 * @class Show
 * @author sb
 * 
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 * 
 */

namespace Sso\Webservices\ObjectBundle\Model\Response\Object\Add;

use Sso\Webservices\ObjectBundle\Model\Response\Object\Base as ObjectBase;
use Sso\Webservices\ObjectBundle\Entity\Object as ObjectEntity;
use Sso\Webservices\ObjectBundle\Model\Response\Object\Add\Entity as ResponseObject;

class Add extends ObjectBase
{

    /**
     *
     * @var \DOMElement
     */
    protected $xmlContainer;

    /**
     *
     * @var ObjectEntity
     */
    protected $objectEntity;

    /**
     * 
     * @param ObjectEntity $objectEntity
     */
    public function init(ObjectEntity $objectEntity)
    {
        //ok first set the db entity
        $this->objectEntity = $objectEntity;
    }

    /**
     * Returns response status
     * 
     * @return string|bool
     */
    protected function getResponseStatus()
    {
        return $this->objectEntity ? 'Success' : 'Failure';
    }

    /**
     * Returns response message
     * 
     * @return string
     */
    protected function getResponseMessage()
    {
        return $this->objectEntity ? false : 'Object data not found';
    }

    /**
     * Build response body
     * 
     * @param \DOMElement $xmlContainer
     */
    protected function buildResponseBody(\DOMElement $xmlContainer)
    {
        parent::buildResponseBody($xmlContainer);
        $this->xmlContainer = $xmlContainer;
        if ($this->objectEntity) {
            $modelOut = $this->apiM->mapper()->modelInToModelOut($this->objectEntity, new ResponseObject());

            $document = $this->apiM->responseBuilder()->document();
            $docFragment = $document->createDocumentFragment();
            $docFragment->appendXML(preg_replace('/^\<?[^\>]*\>\s*/', '', $this->apiM->serializer()->serialize($modelOut, 'xml')));

            $xmlContainer->appendChild($docFragment);
        }
    }

}
