<?php

/**
 * Class Entity
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Response\Object\Delete;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Entity
 *
 * @Serializer\XmlRoot("ObjectType")
 * @Serializer\ExclusionPolicy("all")
 * @package Sso\Webservices\ObjectBundle\Model\Response\Object\Delete
 */
class Entity
{

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Guid")
     * 
     * @var string
     */
    private $guid;

    /**
     * Set $guid
     *
     * @param string $guid
     * @return Type
     */
    public function setGuid($guid)
    {
        $this->guid = $guid;

        return $this;
    }

    /**
     * Get guid
     *
     * @return string 
     */
    public function getGuid()
    {
        return $this->guid;
    }

}
