<?php

/**
 * Class Entity
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Response\Object\ShowSingle;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;
use Sso\ApiBundle\Api\Mapper\Index as Mapper;
use Sso\Webservices\ObjectBundle\Entity\ObjectAttributeValue as ObjectAttributeValueEntity;

/**
 * Class Entity
 *
 * @Serializer\XmlRoot("ObjectType")
 * @Serializer\ExclusionPolicy("all")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Model\Response\Object\ShowSingle
 */
class Entity
{
    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("TypeId")
     * 
     * @var string
     */
    private $typeId;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("TypeName")
     *
     * @var string
     */
    private $typeName;

    /**
     * @var string
     */
    private $parent;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("ParentGuid")
     *
     * @var string
     */
    private $parentGuid;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Guid")
     *
     * @var string
     */
    private $guid;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("ReferenceId")
     *
     * @var string
     */
    private $referenceId;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Name")
     *
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $lowerName;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("TypeOrder")
     *
     * @var int
     */
    private $typeOrder;

    /**
     * @Serializer\Expose
     * @Serializer\Type("DateTime")
     * @Serializer\SerializedName("Created")
     *
     * @var \DateTime
     */
    private $created;

    /**
     * @Serializer\Expose
     * @Serializer\Type("DateTime")
     * @Serializer\SerializedName("Updated")
     *
     * @var \DateTime
     */
    private $updated;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Active")
     *
     * @var string
     */
    private $active;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("Attributes")
     * @Serializer\Type("ArrayCollection<Sso\Webservices\ObjectBundle\Model\Response\Object\ShowSingle\Attribute>")
     * @Serializer\XmlList(entry="Attribute")
     *
     * @var ArrayCollection|Attribute[]
     */
    private $attributes;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("Children")
     * @Serializer\XmlList(inline = false, entry = "Guid")
     * @Serializer\Accessor(getter="getChildrenHelper",setter="setChildrenHelper")
     *
     * @var array
     */
    private $childrenHelper;

    /**
     * @var ArrayCollection
     */
    private $children;

    /**
     * @var Mapper
     */
    private $mapper;

    /**
     * @var string
     */
    private $requestedLangCode;

    /**
     * @param Mapper $mapper
     * @param string $requestedLangCode
     */
    public function __construct(Mapper $mapper, $requestedLangCode)
    {
        $this->mapper = $mapper;
        $this->requestedLangCode = $requestedLangCode;

        $this->attributes = new ArrayCollection();
        $this->children = new ArrayCollection();
    }

    /**
     * Set name
     *
     * @param object $parent
     * @return Entity
     */
    public function setParent($parent)
    {
        $this->parent = $parent;
        if ($this->parent != null) {
            $this->setParentGuid($parent->getGuid());
        }
        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Set name
     *
     * @param string $parentGuid
     * @return Entity
     */
    public function setParentGuid($parentGuid)
    {
        $this->parentGuid = $parentGuid;
        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getParentGuid()
    {
        return $this->parentGuid;
    }

    /**
     * Set $guid
     *
     * @param string $guid
     * @return Entity
     */
    public function setGuid($guid)
    {
        $this->guid = $guid;

        return $this;
    }

    /**
     * Get guid
     *
     * @return string
     */
    public function getGuid()
    {
        return $this->guid;
    }

    /**
     * @return string
     */
    public function getReferenceId()
    {
        return $this->referenceId;
    }

    /**
     * @param string $referenceId
     * @return Entity
     */
    public function setReferenceId($referenceId)
    {
        $this->referenceId = $referenceId;

        return $this;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Entity
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set children
     *
     * @param array $children
     * @return Entity
     */
    public function setChildren($children)
    {
        $this->children = $children;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getChildren()
    {
        return $this->children;
    }

    /**
     * Set lowerName
     *
     * @param string $lowerName
     * @return Entity
     */
    public function setLowerName($lowerName)
    {
        $this->lowerName = $lowerName;

        return $this;
    }

    /**
     * Get lowerName
     *
     * @return string
     */
    public function getLowerName()
    {
        return $this->lowerName;
    }

    /**
     * Set order
     *
     * @param integer $typeOrder
     * @return Entity
     */
    public function setTypeOrder($typeOrder)
    {
        $this->typeOrder = $typeOrder;

        return $this;
    }

    /**
     * Get typeOrder
     *
     * @return integer
     */
    public function getTypeOrder()
    {
        return $this->typeOrder;
    }

    /**
     * Set created
     *
     * @param \DateTime $created
     * @return Entity
     */
    public function setCreated(\DateTime $created)
    {
        $this->created = $created;

        return $this;
    }

    /**
     * Get created
     *
     * @return \DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * Set updated
     *
     * @return Entity
     */
    public function setUpdated()
    {
        $this->updated = new \DateTime();

        return $this;
    }

    /**
     * Get updated
     *
     * @return \DateTime
     */
    public function getUpdated()
    {
        return $this->updated;
    }

    /**
     * Set active
     *
     * @param boolean $active
     * @return Entity
     */
    public function setActive($active)
    {
        $this->active = $active ? '1' : '0';

        return $this;
    }

    /**
     * Get active
     *
     * @return string
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * @param ObjectAttributeValueEntity[] $attributeValues
     * @return Entity
     */
    public function setAttributeValues($attributeValues)
    {
        foreach ($attributeValues as $attributeValue) {

            // Show only attributes for requested language code
            if (null != $this->requestedLangCode && $this->requestedLangCode != $attributeValue->getLanguage()->getId()) {
                continue;
            }

            $attributeItem = new Attribute();
            $attributeItem
                ->setName($attributeValue->getAttribute()->getName())
                ->setAttributeId($attributeValue->getAttribute()->getId())
                ->setValue($attributeValue->getValue())
                ->setValueId($attributeValue->getId())
                ->setGroupId($attributeValue->getAttribute()->getAttributeGroup()->getId())
                ->setGroupName($attributeValue->getAttribute()->getAttributeGroup()->getName())
                ->setMandatory($attributeValue->getAttribute()->getMandatory())
                ->setPossibleValues($attributeValue->getAttribute()->getPossibleValues())
                ->setDefaultValue($attributeValue->getAttribute()->getDefaultValue())
                ->setTranslatable($attributeValue->getAttribute()->getTranslatable())
                ->setLanguageCode($attributeValue->getLanguage()->getId());
            $this->addAttribute($attributeItem);
        }

        return $this;
    }

    /**
     * Get attributes
     *
     * @return ArrayCollection|Attribute[]
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * @param Attribute $attribute
     * @return $this
     */
    public function addAttribute(Attribute $attribute)
    {
        $this->attributes[] = $attribute;

        return $this;
    }

    /**
     * @return array
     */
    public function setChildrenHelper()
    {
        $this->childrenHelper = [];
        if ($this->children) {
            foreach ($this->children as $child) {
                $this->childrenHelper[] = $child->getGuid();
            }
        }
        return $this->childrenHelper;
    }

    /**
     * @return array
     */
    public function getChildrenHelper()
    {
        $this->childrenHelper = [];
        if ($this->children) {
            foreach ($this->children as $child) {
                $this->childrenHelper[] = $child->getGuid();
            }
        }
        return $this->childrenHelper;
    }

    /**
     * @return string
     */
    public function getTypeId()
    {
        return $this->typeId;
    }

    /**
     * @param string $typeId
     * @return Entity
     */
    public function setTypeId($typeId)
    {
        $this->typeId = $typeId;

        return $this;
    }

    /**
     * @return string
     */
    public function getTypeName()
    {
        return $this->typeName;
    }

    /**
     * @param string $typeName
     */
    public function setTypeName($typeName)
    {
        $this->typeName = $typeName;
    }
}
