<?php

/**
 * Class Factory
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Response\Object\ShowSingle;

use Sso\ApiBundle\Api\Manager as ApiManager;
use Sso\Webservices\ObjectBundle\Entity\Object as EntityObject;
use Sso\Webservices\ObjectBundle\Model\Request\Object\ShowSingle\Entity as RequestEntitySingle;

/**
 * Class Factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Model\Response\Object\ShowSingle
 */
class Factory
{

    /**
     * Api Manager
     *
     * @var ApiManager
     */
    private $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @return Entity
     */
    public function entity()
    {
        return new Entity($this->apiM->mapper());
    }

    /**
     * @return Attribute
     */
    public function attribute()
    {
        return new Attribute();
    }

    /**
     * @param EntityObject[] $requestModel
     * @param RequestEntitySingle $helperModel
     * @param int $objectsCount
     */
    public function show($requestModel, $helperModel, $objectsCount)
    {
        $model = new Show($this->apiM);
        $model->init($requestModel, $helperModel, $objectsCount);
        $model->createResponse();
    }

}
