<?php

/**
 * Class Show
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Response\Object\TreeView;

use Sso\Webservices\ObjectBundle\Entity\ObjectAttributeValue;
use Sso\Webservices\ObjectBundle\Model\Response\Type\Base as TypeBase;
use Sso\Webservices\ObjectBundle\Entity\Object as ObjectEntity;
use Sso\Webservices\ObjectBundle\Model\Response\Object\TreeView\Entity as ResponseType;
use LifeStyle\Tools\WebserviceBundle\Error\Type\External as ExternalError;
use Sso\Webservices\ObjectBundle\Model\Request\Object\TreeView\Entity as RequestEntity;

/**
 * Class Show
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Model\Response\Object\TreeView
 */
class Show extends TypeBase
{

    /**
     *
     * @var \DOMElement
     */
    protected $xmlContainer;

    /**
     *
     * @var ObjectEntity[]
     */
    protected $objectEntities;

    /**
     *
     * @var RequestEntity
     */
    protected $helperModel;

    /**
     * @var int
     */
    protected $objectsCount;

    /**
     *
     * @param ObjectEntity[] $objectEntities
     * @param RequestEntity $helperModel
     * @param int $objectsCount
     */
    public function init($objectEntities, $helperModel, $objectsCount)
    {
        //ok first set the db entity
        $this->objectEntities = $objectEntities;
        $this->helperModel = $helperModel;
        $this->objectsCount = $objectsCount;
    }

    /**
     * Returns response status
     *
     * @return string|bool
     */
    protected function getResponseStatus()
    {
        return $this->objectEntities ? 'Success' : 'Failure';
    }

    /**
     * Returns response message
     *
     * @return string
     */
    protected function getResponseMessage()
    {
        return $this->objectEntities ? false : 'Object not found';
    }

    /**
     * Build response body
     *
     * @param \DOMElement $xmlContainer
     */
    protected function buildResponseBody(\DOMElement $xmlContainer)
    {
        parent::buildResponseBody($xmlContainer);
        $this->xmlContainer = $xmlContainer;
        if ($this->objectEntities) {
            //now we are remap enity

            $this->apiM->responseBuilder()->addCount($this->objectsCount);
            if ($this->helperModel->getOffset() !== null) {
                $this->apiM->responseBuilder()->addOffset($this->helperModel->getOffset());
            }
            if ($this->helperModel->getLimit() !== null) {
                $this->apiM->responseBuilder()->addLimit($this->helperModel->getLimit());
            }

            $document = $this->apiM->responseBuilder()->document();

            foreach ($this->objectEntities as $modelIn) {
                /** @var ResponseType $modelOut */
                $modelOut = $this->apiM->mapper()->modelInToModelOut($modelIn, new ResponseType($this->apiM->mapper(), $this->helperModel->getLanguageCode()));

                $docFragment = $document->createDocumentFragment();
                $docFragment->appendXML(preg_replace('/^\<?[^\>]*\>\s*/', '', $this->apiM->serializer()->serialize($modelOut, 'xml')));

                $xmlContainer->appendChild($docFragment);
            }

        } else {
            $this->apiM->errors()->clearErrors();
            $this->apiM->errors()->addError(new ExternalError('os001', 'No objects found.', 'No objects found.', 'No objects found for given guid.'));
        }
    }

}
