<?php

/**
 * Class Entity
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Response\ObjectValue\Update;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Entity
 *
 * @Serializer\XmlRoot("ObjectValueType")
 * @Serializer\ExclusionPolicy("all")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Model\Response\ObjectValue\Update
 */
class Entity
{

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Id")
     *
     * @var string
     */
    private $id;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Value")
     *
     * @var string
     */
    private $value;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("LanguageCode")
     *
     * @var string
     */
    private $languageCode;

    /**
     * @Serializer\Expose
     * @Serializer\Type("DateTime")
     * @Serializer\SerializedName("Created")
     *
     * @var \DateTime
     */
    private $created;

    /**
     * @Serializer\Expose
     * @Serializer\Type("DateTime")
     * @Serializer\SerializedName("Updated")
     *
     * @var \DateTime
     */
    private $updated;

    /**
     * Set id
     *
     * @param string $id
     * @return Entity
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Set value
     *
     * @param string $value
     * @return Entity
     */
    public function setValue($value)
    {
        $this->value = $value;

        return $this;
    }

    /**
     * Set name
     *
     * @param string $languageCode
     * @return Entity
     */
    public function setLanguageCode($languageCode)
    {
        $this->languageCode = $languageCode;

        return $this;
    }

    /**
     * Get created
     *
     * @param \DateTime $created
     * @return \DateTime
     */
    public function setCreated(\DateTime $created)
    {
        $this->created = $created;

        return $this;
    }

    /**
     * Set updated
     *
     * @param \DateTime $updated
     * @return Entity
     */
    public function setUpdated(\DateTime $updated)
    {
        $this->updated = $updated;

        return $this;
    }

}