<?php

/**
 * Response Type Delete
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Response\Type\Delete;

use Sso\Webservices\ObjectBundle\Model\Response\Type\Base as TypeBase;
use Sso\Webservices\ObjectBundle\Entity\Type as TypeEntity;
use Sso\Webservices\ObjectBundle\Model\Response\Type\Delete\Entity as ResponseType;

/**
 * Response Type Delete
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Model\Response\Type\Delete
 */
class Delete extends TypeBase
{

    /**
     *
     * @var \DOMElement
     */
    protected $xmlContainer;

    /**
     *
     * @var TypeEntity
     */
    protected $typeEntity;

    /**
     *
     * @var ResponseType
     */
    protected $responseEntity;

    /**
     *
     * @param TypeEntity $typeEntity
     */
    public function init(TypeEntity $typeEntity)
    {
        //ok first set the db entity
        $this->typeEntity = $typeEntity;
        $modelOut = new ResponseType();
        // now fill response entity
        $this->responseEntity = $this->apiM->mapper()->modelInToModelOut($this->typeEntity, $modelOut);
    }

    /**
     * Returns response status
     *
     * @return string|bool
     */
    protected function getResponseStatus()
    {
        return $this->responseEntity ? 'Success' : 'Failure';
    }

    /**
     * Returns response message
     *
     * @return string
     */
    protected function getResponseMessage()
    {
        return $this->responseEntity ? false : 'Language not found';
    }

    /**
     * Build response body
     *
     * @param \DOMElement $xmlContainer
     */
    protected function buildResponseBody(\DOMElement $xmlContainer)
    {
        parent::buildResponseBody($xmlContainer);
        $this->xmlContainer = $xmlContainer;
        if ($this->responseEntity) {
            //now we are remap entity
            $this->apiM->responseBuilder()->addCount(count($this->responseEntity));
            // Append your data here

            $document = $this->apiM->responseBuilder()->document();
            $docFragment = $document->createDocumentFragment();
            $docFragment->appendXML(preg_replace('/^\<?[^\>]*\>\s*/', '', $this->apiM->serializer()->serialize($this->responseEntity, 'xml')));

            $xmlContainer->appendChild($docFragment);
        }
    }

}
