<?php

/**
 *
 * @class Factory
 * @author sb
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 *
 */

namespace Sso\Webservices\ObjectBundle\Model\Response\Type;

use Sso\Webservices\ObjectBundle\Model\Response\Type\Add;
use Sso\Webservices\ObjectBundle\Model\Response\Type\Show;
use Sso\ApiBundle\Api\Manager as ApiManager;
use Sso\Webservices\ObjectBundle\Entity\Type as TypeEntity;

/**
 * Response factory
 */
class Factory
{
    /**
     * Api Manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @param TypeEntity $requestModel
     */
    public function add($requestModel)
    {
        $model = new Add\Add($this->apiM);
        $model->init($requestModel);
        $model->createResponse();
    }

    /**
     * @param TypeEntity $requestModel
     */
    public function show($requestModel)
    {
        $model = new Show\Show($this->apiM);
        $model->init($requestModel);
        $model->createResponse();
    }

    /**
     * @param TypeEntity $requestModel
     */
    public function update($requestModel)
    {
        $model = new Update\Update($this->apiM);
        $model->init($requestModel);
        $model->createResponse();
    }

    /**
     * @param TypeEntity $requestModel
     */
    public function delete($requestModel)
    {
        $model = new Delete\Delete($this->apiM);
        $model->init($requestModel);
        $model->createResponse();
    }

}