<?php

namespace Sso\Webservices\ObjectBundle\Model\Response\Type\Show;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * @Serializer\XmlRoot("TypeType")
 * @Serializer\ExclusionPolicy("all")
 */
class Entity
{
    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Id")
     *
     * @var string
     */
    private $id;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Name")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\Exclude()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("LowerName")
     *
     * @var string
     */
    private $lowerName;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("TypeOrder")
     *
     * @var int
     */
    private $typeOrder;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("AttributeGroups")
     * @Serializer\Type("ArrayCollection<Sso\Webservices\ObjectBundle\Model\Response\Type\Show\AttributeGroup>")
     * @Serializer\XmlList(entry="AttributeGroup")
     *
     * @var AttributeGroup[]|ArrayCollection
     */
    private $attributeGroups;

    /**
     * @Serializer\Expose
     * @Serializer\Type("DateTime")
     * @Serializer\SerializedName("Created")
     *
     * Define Var Type
     * @var \DateTime
     *
     */
    private $created;

    /**
     * @Serializer\Expose
     * @Serializer\Type("DateTime")
     * @Serializer\SerializedName("Updated")
     *
     * Define Var Type
     * @var \DateTime
     *
     */
    private $updated;

    /**
     * Set id
     *
     * @param string $id
     * @return Entity
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get id
     *
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Entity
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set lowerName
     *
     * @param string $lowerName
     * @return Entity
     */
    public function setLowerName($lowerName)
    {
        $this->lowerName = $lowerName;

        return $this;
    }

    /**
     * Get lowerName
     *
     * @return string
     */
    public function getLowerName()
    {
        return $this->lowerName;
    }

    /**
     * Set order
     *
     * @param integer $typeOrder
     * @return Entity
     */
    public function setTypeOrder($typeOrder)
    {
        $this->typeOrder = $typeOrder;

        return $this;
    }

    /**
     * Get typeOrder
     *
     * @return integer
     */
    public function getTypeOrder()
    {
        return $this->typeOrder;
    }

    /**
     * Set created
     *
     * @param \DateTime $created
     * @return Entity
     */
    public function setCreated(\DateTime $created)
    {
        $this->created = $created;

        return $this;
    }

    /**
     * Get created
     *
     * @return \DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * Set updated
     */
    public function setUpdated()
    {
        $this->updated = new \DateTime();
    }

    /**
     * Get updated
     *
     * @return \DateTime
     */
    public function getUpdated()
    {
        return $this->updated;
    }

    /**
     * @return AttributeGroup[]|ArrayCollection
     */
    public function getAttributeGroups()
    {
        return $this->attributeGroups;
    }

    /**
     * @param AttributeGroup $attributeGroup
     * @return Entity
     */
    public function setAttributeGroup(AttributeGroup $attributeGroup)
    {
        if (!$this->attributeGroups) {
            $this->attributeGroups = new ArrayCollection();
        }

        if (!$this->attributeGroups->contains($attributeGroup)) {
            $this->attributeGroups->add(($attributeGroup));
        }

        return $this;
    }

    /**
     * @param $attributeGroups
     * @return Entity
     */
    public function setAttributeGroups($attributeGroups)
    {
        if (!$this->attributeGroups) {
            $this->attributeGroups = new ArrayCollection();
        }

        foreach ($attributeGroups as $attributeGroup) {
            $responseAttributeGroup = new AttributeGroup();
            $attributes = new ArrayCollection();
            $reqAttributes = $attributeGroup->getAttributes();

            if (!empty($reqAttributes) && !$reqAttributes->isEmpty()) {
                foreach ($reqAttributes as $attribute) {
                    $respAttribute = new Attribute();
                    $respAttribute
                        ->setId($attribute->getId())
                        ->setName($attribute->getName())
                        ->setMandatory($attribute->getMandatory())
                        ->setPossibleValues($attribute->getPossibleValues())
                        ->setDefaultValue($attribute->getDefaultValue())
                        ->setTranslatable($attribute->getTranslatable());

                    $attributes->add($respAttribute);
                }
            }

            $responseAttributeGroup
                ->setId($attributeGroup->getId())
                ->setName($attributeGroup->getName())
                ->setCreated($attributeGroup->getCreated())
                ->setUpdated($attributeGroup->getUpdated())
                ->setAttributes($attributes);

            $this->attributeGroups->add($responseAttributeGroup);
        }

        return $this;
    }
}
