<?php

/**
 * Class AttributeControllerTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Tests\Controller;

use Doctrine\Common\DataFixtures\Executor\ORMExecutor;
use Doctrine\Common\DataFixtures\Loader;
use Doctrine\Common\DataFixtures\Purger\ORMPurger;
use Guzzle\Service\Client;
use LifeStyle\Tools\CredentialsBundle\DataFixtures\ORM\LoadServiceNames;
use LifeStyle\Tools\CredentialsBundle\DataFixtures\ORM\LoadServiceNames2Services;
use LifeStyle\Tools\CredentialsBundle\DataFixtures\ORM\LoadServices;
use LifeStyle\Tools\CredentialsBundle\DataFixtures\ORM\LoadTokens;
use LifeStyle\Tools\CredentialsBundle\DataFixtures\ORM\LoadTokens2ServiceNames;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Sso\Webservices\ObjectBundle\Worker\Factory as WorkerFactory;
use Sso\ApiBundle\Api\Manager as ApiManager;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

/**
 * Class AttributeControllerTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Tests\Controller
 */
class AttributeControllerTest extends ControllerTestCase
{

    /**
     * @var WorkerFactory
     */
    protected $worker;

    protected function setUp()
    {
        parent::setUp();

        date_default_timezone_set('Europe/Berlin');

        $this->worker = new WorkerFactory($this->apiM());
    }

    public function testWorkerAttributeShowAllSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Attribute>
                                <Show>
                                    <AttributeType>
                                    </AttributeType>
                                </Show>
                            </Attribute>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->attribute()->show($xml->Attribute->Show);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $expectedBag = [
            '0C7D874E-A114-BF02-81D4-EC7935C748CA' => 'UnitTestAttributeOne',
            '229B72CA-1927-68B2-5AEB-E87C74AF717E' => 'UnitTestAttributeTwo',
        ];

        foreach ($responseXml->Unknown->Unknown->AttributeType as $attribute) {
            $this->assertTrue(isset($expectedBag[(string) $attribute->Id]));
            $this->assertEquals($expectedBag[(string) $attribute->Id], $attribute->Name);
        }

        $this->assertEquals('Success', $responseXml->Status);
    }

    public function testWorkerAttributeShowWithOffsetAndLimitSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Attribute>
                                <Show>
                                    <AttributeType>
                                        <Offset>1</Offset>
                                        <Limit>1</Limit>
                                    </AttributeType>
                                </Show>
                            </Attribute>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->attribute()->show($xml->Attribute->Show);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $expectedBag = [
            '229B72CA-1927-68B2-5AEB-E87C74AF717E' => 'UnitTestAttributeTwo',
        ];

        $this->assertSame(1, count($responseXml->Unknown->Unknown->AttributeType));

        $attribute = $responseXml->Unknown->Unknown->AttributeType[0];
        $this->assertTrue(isset($expectedBag[(string) $attribute->Id]));
        $this->assertEquals($expectedBag[(string) $attribute->Id], $attribute->Name);

        $this->assertEquals('Success', $responseXml->Status);
    }

    public function testWorkerAttributeShowByIdSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Attribute>
                                <Show>
                                    <AttributeType>
                                        <Id>0C7D874E-A114-BF02-81D4-EC7935C748CA</Id>
                                    </AttributeType>
                                </Show>
                            </Attribute>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->attribute()->show($xml->Attribute->Show);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('0C7D874E-A114-BF02-81D4-EC7935C748CA', $responseXml->Unknown->Unknown->AttributeType->Id);
        $this->assertEquals('UnitTestAttributeOne', $responseXml->Unknown->Unknown->AttributeType->Name);
    }

    public function testWorkerAttributeUpdateSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Attribute>
                                <Update>
                                    <AttributeType>
                                        <Id>229B72CA-1927-68B2-5AEB-E87C74AF717E</Id>
                                        <Name>UnitTestAttributeTwoUpdated</Name>
                                        <GroupId>B3AB16CB-8E3D-36D7-33A6-B59A7CD7C49E</GroupId>
                                    </AttributeType>
                                </Update>
                            </Attribute>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->attribute()->update($xml->Attribute->Update);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('229B72CA-1927-68B2-5AEB-E87C74AF717E', $responseXml->Unknown->Unknown->AttributeType->Id);
        $this->assertEquals('UnitTestAttributeTwoUpdated', $responseXml->Unknown->Unknown->AttributeType->Name);
        $this->assertEquals('B3AB16CB-8E3D-36D7-33A6-B59A7CD7C49E', $responseXml->Unknown->Unknown->AttributeType->GroupId);
    }

    public function testWorkerAttributeAddSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Attribute>
                                <Add>
                                    <AttributeType>
                                        <Name>UnitTestAttributeAdd</Name>
                                        <GroupId>B3AB16CB-8E3D-36D7-33A6-B59A7CD7C49E</GroupId>
                                    </AttributeType>
                                </Add>
                            </Attribute>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->attribute()->add($xml->Attribute->Add);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals(36, strlen($responseXml->Unknown->Unknown->AttributeType->Id));
        $this->assertEquals('UnitTestAttributeAdd', $responseXml->Unknown->Unknown->AttributeType->Name);
        $this->assertEquals('B3AB16CB-8E3D-36D7-33A6-B59A7CD7C49E', $responseXml->Unknown->Unknown->AttributeType->GroupId);
    }

    public function testWorkerAttributeDeleteSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Attribute>
                                <Delete>
                                    <AttributeType>
                                        <Id>229B72CA-1927-68B2-5AEB-E87C74AF717E</Id>
                                    </AttributeType>
                                </Delete>
                            </Attribute>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->attribute()->delete($xml->Attribute->Delete);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('229B72CA-1927-68B2-5AEB-E87C74AF717E', $responseXml->Unknown->Unknown->AttributeType->Id);
    }

}
