<?php

/**
 * Class ControllerTestCase
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Tests\Controller;

use Sso\Webservices\ObjectBundle\Tests\Controller\WebserviceTestCase;
use Sso\ApiBundle\Api\Response\Builder as XmlResponse;

/**
 * Class ControllerTestCase
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Tests\Controller
 */
class ControllerTestCase extends WebserviceTestCase
{

    /**
     * Xml credentials
     * 
     * @var string
     */
    protected $xmlCredentials;

    /**
     * Setup some defaults
     */
    protected function setUp()
    {
        parent::setUp();

        $this->xmlCredentials = "<Credentials>
                    <ServiceProvider>
                        <ServiceToken>" . $this->ServiceToken . "</ServiceToken>
                        <ServiceName>" . $this->ServiceName . "</ServiceName>
                    </ServiceProvider>
                    <ServiceTrigger>
                        <UserIdentifier>" . $this->UserIdentifier . "</UserIdentifier>
                    </ServiceTrigger>
                    <ServiceCountry>
                        <Code>" . $this->ServiceCountryCode . "</Code>
                    </ServiceCountry>
                </Credentials>";
    }

    /**
     * Xml response document
     * 
     * @return XmlResponse
     */
    protected function xmlResponse()
    {
        return new XmlResponse();
    }

}
