<?php

/**
 * Class LanguageControllerTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Tests\Controller;

use Sso\Webservices\ObjectBundle\Worker\Factory as WorkerFactory;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

/**
 * Class LanguageControllerTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Tests\Controller
 */
class LanguageControllerTest extends ControllerTestCase
{

    /**
     * @var WorkerFactory
     */
    protected $worker;

    protected function setUp()
    {
        parent::setUp();

        date_default_timezone_set('Europe/Berlin');

        $this->worker = new WorkerFactory($this->apiM());
    }

    public function testWorkerLanguageShowAllSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Language>
                                <Show>
                                    <LanguageType>
                                    </LanguageType>
                                </Show>
                            </Language>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->language()->show($xml->Language->Show);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertNotEmpty((string) $responseXml->Unknown->Unknown->LanguageType->Code);
        $this->assertNotEmpty((string) $responseXml->Unknown->Unknown->LanguageType->Name);
    }

    public function testWorkerLanguageShowByCodeSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Language>
                                <Show>
                                    <LanguageType>
                                        <Code>en</Code>
                                    </LanguageType>
                                </Show>
                            </Language>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->language()->show($xml->Language->Show);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('en', $responseXml->Unknown->Unknown->LanguageType->Code);
        $this->assertEquals('English', $responseXml->Unknown->Unknown->LanguageType->Name);
    }

}
