<?php

/**
 * Class ObjectControllerTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Tests\Controller;

use Sso\Webservices\ObjectBundle\Worker\Factory as WorkerFactory;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

/**
 * Class ObjectControllerTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Tests\Controller
 */
class ObjectControllerTest extends ControllerTestCase
{

    /**
     * @var WorkerFactory
     */
    protected $worker;

    protected function setUp()
    {
        parent::setUp();

        date_default_timezone_set('Europe/Berlin');

        $this->worker = new WorkerFactory($this->apiM());
    }

    public function testWorkerObjectShowSingleAllSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Object>
                                <ShowSingle>
                                    <ObjectType>
                                    </ObjectType>
                                </ShowSingle>
                            </Object>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->object()->showSingle($xml->Object->ShowSingle);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('16FA40FD-5F4B-4937-F53E-F598471AAFD8', $responseXml->Unknown->Unknown->ObjectType->Guid);
    }

    public function testWorkerObjectShowSingleByGuidSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Object>
                                <ShowSingle>
                                    <ObjectType>
                                        <Guid>16FA40FD-5F4B-4937-F53E-F598471AAFD8</Guid>
                                    </ObjectType>
                                </ShowSingle>
                            </Object>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->object()->showSingle($xml->Object->ShowSingle);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('16FA40FD-5F4B-4937-F53E-F598471AAFD8', $responseXml->Unknown->Unknown->ObjectType->Guid);
    }

    public function testWorkerObjectShowSingleByReferenceIdSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Object>
                                <ShowSingle>
                                    <ObjectType>
                                        <ReferenceId>UnitTestReferenceId001</ReferenceId>
                                    </ObjectType>
                                </ShowSingle>
                            </Object>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->object()->showSingle($xml->Object->ShowSingle);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('UnitTestReferenceId001', $responseXml->Unknown->Unknown->ObjectType->ReferenceId);
        $this->assertEquals('16FA40FD-5F4B-4937-F53E-F598471AAFD8', $responseXml->Unknown->Unknown->ObjectType->Guid);
    }

    public function testWorkerObjectShowMultiAllSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Object>
                                <ShowMulti>
                                    <ObjectType>
                                    </ObjectType>
                                </ShowMulti>
                            </Object>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->object()->showMulti($xml->Object->ShowMulti);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('16FA40FD-5F4B-4937-F53E-F598471AAFD8', $responseXml->Unknown->Unknown->ObjectType->Guid);
    }

    public function testWorkerObjectTreeViewAllSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Object>
                                <TreeView>
                                    <ObjectType>
                                        <FullResponse>0</FullResponse>
                                    </ObjectType>
                                </TreeView>
                            </Object>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->object()->treeView($xml->Object->TreeView);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('16FA40FD-5F4B-4937-F53E-F598471AAFD8', $responseXml->Unknown->Unknown->ObjectType->Guid);
    }

    public function testWorkerObjectTreeViewByGuidSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Object>
                                <TreeView>
                                    <ObjectType>
                                        <Guid>16FA40FD-5F4B-4937-F53E-F598471AAFD8</Guid>
                                        <FullResponse>0</FullResponse>
                                    </ObjectType>
                                </TreeView>
                            </Object>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->object()->showMulti($xml->Object->ShowMulti);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('16FA40FD-5F4B-4937-F53E-F598471AAFD8', $responseXml->Unknown->Unknown->ObjectType->Guid);
    }


    public function testWorkerObjectTreeViewIdRegen()
    {

    }
    

    public function testWorkerObjectShowMultiByGuidSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Object>
                                <ShowMulti>
                                    <ObjectType>
                                        <Guid>16FA40FD-5F4B-4937-F53E-F598471AAFD8</Guid>
                                    </ObjectType>
                                </ShowMulti>
                            </Object>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->object()->showMulti($xml->Object->ShowMulti);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('16FA40FD-5F4B-4937-F53E-F598471AAFD8', $responseXml->Unknown->Unknown->ObjectType->Guid);
    }

    public function testWorkerObjectShowMultiByReferenceIdSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Object>
                                <ShowMulti>
                                    <ObjectType>
                                        <ReferenceId>UnitTestReferenceId001</ReferenceId>
                                    </ObjectType>
                                </ShowMulti>
                            </Object>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->object()->showMulti($xml->Object->ShowMulti);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('UnitTestReferenceId001', $responseXml->Unknown->Unknown->ObjectType->ReferenceId);
        $this->assertEquals('16FA40FD-5F4B-4937-F53E-F598471AAFD8', $responseXml->Unknown->Unknown->ObjectType->Guid);
    }

    public function testWorkerObjectShowMultiByTypeIdentifierSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Object>
                                <ShowMulti>
                                    <ObjectType>
                                        <Type>location</Type>
                                    </ObjectType>
                                </ShowMulti>
                            </Object>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->object()->showMulti($xml->Object->ShowMulti);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('16FA40FD-5F4B-4937-F53E-F598471AAFD8', $responseXml->Unknown->Unknown->ObjectType->Guid);
    }

    public function testWorkerObjectUpdateSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Object>
                                <Update>
                                    <ObjectType>
                                        <Guid>16FA40FD-5F4B-4937-F53E-F598471AAFD8</Guid>
                                        <Name>TestNameUpdate</Name>
                                        <ParentGuid>DF04AF16-5F4B-F53E-4937-F598471AAFD8</ParentGuid>
                                        <TypeId>E43752BB-E4F7-878A-BFF8-B2F0F38142F7</TypeId>
                                        <Active>false</Active>
                                    </ObjectType>
                                </Update>
                            </Object>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->object()->update($xml->Object->Update);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('16FA40FD-5F4B-4937-F53E-F598471AAFD8', $responseXml->Unknown->Unknown->ObjectType->Guid);
        $this->assertEquals('TestNameUpdate', $responseXml->Unknown->Unknown->ObjectType->Name);
        $this->assertEquals('DF04AF16-5F4B-F53E-4937-F598471AAFD8', $responseXml->Unknown->Unknown->ObjectType->ParentGuid);
        $this->assertEquals('E43752BB-E4F7-878A-BFF8-B2F0F38142F7', $responseXml->Unknown->Unknown->ObjectType->TypeId);
        $this->assertEquals('0', (string) $responseXml->Unknown->Unknown->ObjectType->Active);
    }

    public function testWorkerObjectAddSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Object>
                                <Add>
                                    <ObjectType>
                                        <ReferenceId>UT00001</ReferenceId>
                                        <Name>TestObjectAddName</Name>
                                        <ParentGuid>DF04AF16-5F4B-F53E-4937-F598471AAFD8</ParentGuid>
                                        <TypeId>E43752BB-E4F7-878A-BFF8-B2F0F38142F7</TypeId>
                                        <Active>true</Active>
                                    </ObjectType>
                                </Add>
                            </Object>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->object()->add($xml->Object->Add);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('TestObjectAddName', $responseXml->Unknown->Unknown->ObjectType->Name);
        $this->assertEquals('DF04AF16-5F4B-F53E-4937-F598471AAFD8', $responseXml->Unknown->Unknown->ObjectType->ParentGuid);
        $this->assertEquals('E43752BB-E4F7-878A-BFF8-B2F0F38142F7', $responseXml->Unknown->Unknown->ObjectType->TypeId);
        $this->assertEquals('0', (string) $responseXml->Unknown->Unknown->ObjectType->Active);
    }

    public function testWorkerObjectDeleteByGuidSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Object>
                                <Delete>
                                    <ObjectType>
                                        <Guid>DF04AF16-5F4B-F53E-4937-F598471AAFD8</Guid>
                                    </ObjectType>
                                </Delete>
                            </Object>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->object()->delete($xml->Object->Delete);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('DF04AF16-5F4B-F53E-4937-F598471AAFD8', $responseXml->Unknown->Unknown->ObjectType->Guid);

        $entity = $this->worker->objectDbM()->respository()->object()->find('DF04AF16-5F4B-F53E-4937-F598471AAFD8');
        if ($entity) {
            $this->fail('Test failed! Object entity has not been deleted!');
        }
    }

    public function testWorkerObjectDeleteByReferenceIdSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Object>
                                <Delete>
                                    <ObjectType>
                                        <ReferenceId>UnitTestReferenceId002</ReferenceId>
                                    </ObjectType>
                                </Delete>
                            </Object>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->object()->delete($xml->Object->Delete);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('DF04AF16-5F4B-F53E-4937-F598471AAFD8', $responseXml->Unknown->Unknown->ObjectType->Guid);

        $entity = $this->worker->objectDbM()->respository()->object()->find('DF04AF16-5F4B-F53E-4937-F598471AAFD8');
        if ($entity) {
            $this->fail('Test failed! Object entity has not been deleted!');
        }
    }

}
