<?php

/**
 * Class ObjectValueControllerTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Tests\Controller;

use Sso\Webservices\ObjectBundle\Worker\Factory as WorkerFactory;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

/**
 * Class ObjectValueControllerTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Tests\Controller
 */
class ObjectValueControllerTest extends ControllerTestCase
{

    /**
     * @var WorkerFactory
     */
    protected $worker;

    protected function setUp()
    {
        parent::setUp();

        date_default_timezone_set('Europe/Berlin');

        $this->worker = new WorkerFactory($this->apiM());
    }

    public function testWorkerObjectValueShowAllSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <ObjectValue>
                                <Show>
                                    <ObjectValueType>
                                    </ObjectValueType>
                                </Show>
                            </ObjectValue>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->objectValue()->show($xml->ObjectValue->Show);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $expectedBag = [
            '24F07207-4874-7CD2-0A3D-271146ED10F3' => ['16FA40FD-5F4B-4937-F53E-F598471AAFD8', 'UnitTestObject1', '0C7D874E-A114-BF02-81D4-EC7935C748CA', 'UnitTestAttributeOne', 'UnitTestValueEN', 'en'],
            'F9F07207-7CD2-4874-4A1D-U71146ED10F3' => ['16FA40FD-5F4B-4937-F53E-F598471AAFD8', 'UnitTestObject1', '0C7D874E-A114-BF02-81D4-EC7935C748CA', 'UnitTestAttributeOne', 'UnitTestValueDE', 'de'],
        ];

        foreach ($responseXml->Unknown->Unknown->ObjectValueType as $objectValue) {
            $this->assertTrue(isset($expectedBag[(string) $objectValue->Id]));
            $this->assertEquals($expectedBag[(string) $objectValue->Id][0], $objectValue->ObjectGuid);
            $this->assertEquals($expectedBag[(string) $objectValue->Id][1], $objectValue->ObjectName);
            $this->assertEquals($expectedBag[(string) $objectValue->Id][2], $objectValue->AttributeId);
            $this->assertEquals($expectedBag[(string) $objectValue->Id][3], $objectValue->AttributeName);
            $this->assertEquals($expectedBag[(string) $objectValue->Id][4], $objectValue->Value);
            $this->assertEquals($expectedBag[(string) $objectValue->Id][5], $objectValue->LanguageCode);
        }

        $this->assertEquals('Success', $responseXml->Status);
    }

    public function testWorkerObjectValueShowByIdSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <ObjectValue>
                                <Show>
                                    <ObjectValueType>
                                        <Id>F9F07207-7CD2-4874-4A1D-U71146ED10F3</Id>
                                    </ObjectValueType>
                                </Show>
                            </ObjectValue>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->objectValue()->show($xml->ObjectValue->Show);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('F9F07207-7CD2-4874-4A1D-U71146ED10F3', $responseXml->Unknown->Unknown->ObjectValueType->Id);
    }

    public function testWorkerObjectValueUpdateSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <ObjectValue>
                                <Update>
                                    <ObjectValueType>
                                        <Id>24F07207-4874-7CD2-0A3D-271146ED10F3</Id>
                                        <Value>test value english</Value>
                                        <LanguageCode>en</LanguageCode>
                                    </ObjectValueType>
                                </Update>
                            </ObjectValue>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->objectValue()->update($xml->ObjectValue->Update);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('24F07207-4874-7CD2-0A3D-271146ED10F3', $responseXml->Unknown->Unknown->ObjectValueType->Id);
    }

    public function testWorkerObjectValueAddSuccess()
    {
        $this->markTestSkipped('This test is buggy, so skip it. It has to be fixed!');
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <ObjectValue>
                                <Add>
                                    <ObjectGuid>DF04AF16-5F4B-F53E-4937-F598471AAFD8</ObjectGuid>
                                    <ObjectValue>UnitTestAddObjectValueDE</ObjectValue>
                                    <LanguageCode>de</LanguageCode>
                                    <AttributeId>0C7D874E-A114-BF02-81D4-EC7935C748CA</AttributeId>
                                </Add>
                            </ObjectValue>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->objectValue()->add($xml->ObjectValue->Add);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        #$this->assertEquals('24F07207-4874-7CD2-0A3D-271146ED10F3', $responseXml->Unknown->Unknown->ObjectValueType->Id);
    }

    public function testWorkerObjectValueDeleteSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <ObjectValue>
                                <Delete>
                                    <ObjectValueType>
                                        <Id>24F07207-4874-7CD2-0A3D-271146ED10F3</Id>
                                    </ObjectValueType>
                                </Delete>
                            </ObjectValue>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->objectValue()->update($xml->ObjectValue->Delete);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('24F07207-4874-7CD2-0A3D-271146ED10F3', $responseXml->Unknown->Unknown->ObjectValueType->Id);
    }

}
