<?php

/**
 * Class Index
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Worker\Attribute;

use Sso\Webservices\ObjectBundle\Worker\Factory as WorkerFactory;
use LifeStyle\Tools\WebserviceBundle\Exception\InvalidRecordException;
use Sso\ApiBundle\Api\Manager as ApiManager;

/**
 * Class Index
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Worker\Attribute
 */
class Index
{

    /**
     * Api Manager
     * 
     * @var ApiManager
     */
    private $apiM;

    /**
     *
     * @var WorkerFactory
     */
    private $woM;

    /**
     * Constructor
     * 
     * @param WorkerFactory $woM
     */
    public function __construct(WorkerFactory $woM)
    {
        $this->woM = $woM;
        $this->apiM = $this->woM->apiM();
    }

    /**
     * Show attribute
     * 
     * @param \SimpleXMLElement $xml Record
     */
    public function show(\SimpleXMLElement $xml)
    {
        $this->apiM->errors()->clearErrors();
        try {
            $attributeShowRequest = $this->woM->modelFactory()->request()->attribute()->show($xml);
            $this->woM->modelFactory()->response()->attribute()->show($attributeShowRequest->getAttributeModels(), $attributeShowRequest->getAttributesCount(), $attributeShowRequest->getRequestModel());
        } catch (InvalidRecordException $e) {
            // Catch invalid record contents only
            $this->apiM->responseBuilder()->endAction();
        }
    }

    /**
     * Add attribute
     * 
     * @param \SimpleXMLElement $xml Record
     */
    public function add(\SimpleXMLElement $xml)
    {
        $this->apiM->errors()->clearErrors();
        try {
            $attributeAddRequest = $this->woM->modelFactory()->request()->attribute()->add($xml);
            $this->woM->modelFactory()->response()->attribute()->add($attributeAddRequest->getAttributeModel());
        } catch (InvalidRecordException $e) {
            // Catch invalid record contents only
            $this->apiM->responseBuilder()->endAction();
        }
    }

    /**
     * Update attribute
     *
     * @param \SimpleXMLElement $xml Record
     */
    public function update(\SimpleXMLElement $xml)
    {
        $this->apiM->errors()->clearErrors();
        try {
            $attributeShowRequest = $this->woM->modelFactory()->request()->attribute()->update($xml);
            $this->woM->modelFactory()->response()->attribute()->update($attributeShowRequest->getAttributeModel());
        } catch (InvalidRecordException $e) {
            // Catch invalid record contents only
            $this->apiM->responseBuilder()->endAction();
        }
    }

    /**
     * Delete attribute
     *
     * @param \SimpleXMLElement $xml Record
     */
    public function delete(\SimpleXMLElement $xml)
    {
        $this->apiM->errors()->clearErrors();
        try {
            $attributeShowRequest = $this->woM->modelFactory()->request()->attribute()->delete($xml);
            $this->woM->modelFactory()->response()->attribute()->delete($attributeShowRequest->getAttributeModel());
        } catch (InvalidRecordException $e) {
            // Catch invalid record contents only
            $this->apiM->responseBuilder()->endAction();
        }
    }

}