<?php

/**
 * 
 * @class Manager
 * @author sb
 * 
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 * 
 */

namespace Sso\Webservices\ObjectBundle\Worker;

use Sso\Webservices\ObjectBundle\Model\Factory as ModelFactory;
use LifeStyle\Tools\WebserviceBundle\Response\Builder as ResponseBuilder;
use Symfony\Component\DependencyInjection\ContainerInterface as Container;

use Sso\Webservices\ObjectBundle\Worker\Type\Index as TypeIndex;
use Sso\Webservices\ObjectBundle\Worker\Object\Index as ObjectIndex;
use Sso\Webservices\ObjectBundle\Worker\Language\Index as LanguageIndex;
use Sso\Webservices\ObjectBundle\Worker\AttributeGroup\Index as AttributeGroupIndex;
use Sso\Webservices\ObjectBundle\Worker\Attribute\Index as AttributeIndex;
use Sso\Webservices\ObjectBundle\Worker\ObjectValue\Index as ObjectValueIndex;
use Sso\ApiBundle\Api\Manager as ApiManager;
use Sso\Webservices\ObjectBundle\Database\Manager as ObjectDbM;
/**
 * Worker Factory
 */
class Factory
{

    /**
     * Model factory class
     * 
     * @var ModelFactory
     */
    protected $modelFactory;

    /**
     * List of factory objects
     * 
     * @var array
     */
    private $factory = array();

     /**
     *
     * @var Manager\Index
     */
    protected $apiM;

    /**
     * 
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @return ApiManager
     */
    public function apiM()
    {
        return $this->apiM;
    }
    
     /**
     * 
     * @return ObjectDbM
     */
    public function objectDbM()
    {
        return $this->apiM->getContainer()->get('object_database_manager');
    }

    /**
     * Model factory class
     * 
     * @return ModelFactory
     */
    public function modelFactory()
    {
        return null !== $this->modelFactory ? $this->modelFactory : ($this->modelFactory = new ModelFactory($this->apiM));
    }

    /** 
     * @return TypeIndex
     */
    public function type()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new TypeIndex($this));
    }
    
    /** 
     * @return LanguageIndex
     */
    public function language()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new LanguageIndex($this));
    }
    
    /** 
     * @return ObjectIndex
     */
    public function object()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new ObjectIndex($this));
    }
    
    /** 
     * @return AttributeGroupIndex
     */
    public function attributeGroup()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new AttributeGroupIndex($this));
    }
    
    /** 
     * @return AttributeIndex
     */
    public function attribute()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new AttributeIndex($this));
    }
    
    /** 
     * @return ObjectValueIndex
     */
    public function objectValue()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new ObjectValueIndex($this));
    }
 
}