<?php

/**
 * 
 * @class Language
 * @author sb
 * 
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 * 
 */

namespace Sso\Webservices\ObjectBundle\Worker\Language;

use Sso\Webservices\ObjectBundle\Worker\Factory as WorkerFactory;
use LifeStyle\Tools\WebserviceBundle\Error\Type\External as ExternalError;

use Sso\ApiBundle\Api\Manager as ApiManager;


class Index
{

    /**
     * Api Manager
     * 
     * @var ApiManager
     */
    private $apiM;

    /**
     *
     * @var WorkerManager
     */
    private $woM;

    
    /**
     * Constructor
     * 
     * @param WorkerFactory $woM
     */
    public function __construct(WorkerFactory $woM)
    {
        $this->woM = $woM;
        $this->apiM = $this->woM->apiM();
    }

     /**
     * show object
     * 
     * @param \SimpleXMLElement $xml Record
     */
    public function show(\SimpleXMLElement $xml)
    {
        $this->apiM->errors()->clearErrors();
        try {
            $languageRequest = $this->woM->modelFactory()->request()->language()->show($xml);
            $this->woM->modelFactory()->response()->language()->show($languageRequest->getLanguageModel(), $languageRequest->getLanguagesCount());
        } catch (\Exception $e) {
            echo $e->getMessage();
            // Catch invalid record contents only
            $this->apiM->responseBuilder()->endAction();
        }
    }

}
