<?php

/**
 * Class Index
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Worker\ObjectValue;

use Sso\Webservices\ObjectBundle\Worker\Factory as WorkerFactory;
use LifeStyle\Tools\WebserviceBundle\Exception\InvalidRecordException;
use Sso\ApiBundle\Api\Manager as ApiManager;

/**
 * Class Index
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Worker\ObjectValue
 */
class Index
{

    /**
     * Api Manager
     * 
     * @var ApiManager
     */
    private $apiM;

    /**
     * @var WorkerFactory
     */
    private $woM;

    /**
     * Constructor
     * 
     * @param WorkerFactory $woM
     */
    public function __construct(WorkerFactory $woM)
    {
        $this->woM = $woM;
        $this->apiM = $this->woM->apiM();
    }

    /**
     * Show object value
     * 
     * @param \SimpleXMLElement $xml Record
     */
    public function show(\SimpleXMLElement $xml)
    {
        $this->apiM->errors()->clearErrors();
        try {
            $objectValueRequest = $this->woM->modelFactory()->request()->objectValue()->show($xml);
            $this->woM->modelFactory()->response()->objectValue()->show($objectValueRequest->getObjectValueModels(), $objectValueRequest->getHelperModel(), $objectValueRequest->getObjectsValueCount());
        } catch (InvalidRecordException $e) {
            // Catch invalid record contents only
            $this->apiM->responseBuilder()->endAction();
        }
    }

    /**
     * Add object value
     * 
     * @param \SimpleXMLElement $xml Record
     */
    public function add(\SimpleXMLElement $xml)
    {
        $this->apiM->errors()->clearErrors();
        try {
            $objectValueRequest = $this->woM->modelFactory()->request()->objectValue()->add($xml);
            $this->woM->modelFactory()->response()->objectValue()->add($objectValueRequest->getObjectAttributeValue());
        } catch (InvalidRecordException $e) {
            // Catch invalid record contents only
            $this->apiM->responseBuilder()->endAction();
        }
    }

    /**
     * Update object value
     *
     * @param \SimpleXMLElement $xml
     */
    public function update(\SimpleXMLElement $xml)
    {
        $this->apiM->errors()->clearErrors();
        try {
            $objectValueRequest = $this->woM->modelFactory()->request()->objectValue()->update($xml);
            $this->woM->modelFactory()->response()->objectValue()->update($objectValueRequest->getObjectValueEntity(), $objectValueRequest->getHelperModel());
        } catch (InvalidRecordException $e) {
            // Catch invalid record contents only
            $this->apiM->responseBuilder()->endAction();
        }
    }

    /**
     * Delete object value
     *
     * @param \SimpleXMLElement $xml
     */
    public function delete(\SimpleXMLElement $xml)
    {
        $this->apiM->errors()->clearErrors();
        try {
            $objectValueRequest = $this->woM->modelFactory()->request()->objectValue()->delete($xml);
            $this->woM->modelFactory()->response()->objectValue()->delete($objectValueRequest->getObjectValueEntity(), $objectValueRequest->getHelperModel());
        } catch (InvalidRecordException $e) {
            // Catch invalid record contents only
            $this->apiM->responseBuilder()->endAction();
        }
    }

}