<?php

/**
 * 
 * @class Language
 * @author sb
 * 
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 * 
 */

namespace Sso\Webservices\ObjectBundle\Worker\Type;

use Sso\Webservices\ObjectBundle\Worker\Factory as WorkerFactory;
use LifeStyle\Tools\WebserviceBundle\Exception\InvalidRecordException;
use Sso\ApiBundle\Api\Manager as ApiManager;


class Index
{

    /**
     * Api Manager
     * 
     * @var ApiManager
     */
    private $apiM;

    /**
     *
     * @var WorkerManager
     */
    private $woM;

    
    /**
     * Constructor
     * 
     * @param WorkerFactory $woM
     */
    public function __construct(WorkerFactory $woM)
    {
        $this->woM = $woM;
        $this->apiM = $this->woM->apiM();
    }

    /**
     * add type
     * 
     * @param \SimpleXMLElement $xml Record
     */
    public function add(\SimpleXMLElement $xml)
    {
        $this->apiM->errors()->clearErrors();
        try {
            $typeAddReq = $this->woM->modelFactory()->request()->type()->add($xml);
            $this->woM->modelFactory()->response()->type()->add($typeAddReq->getTypeModel());
        } catch (InvalidRecordException $e) {
            // Catch invalid record contents only
            $this->apiM->responseBuilder()->endAction();
        }
    }
    
    /**
     * add type
     * 
     * @param \SimpleXMLElement $xml Record
     */
    public function show(\SimpleXMLElement $xml)
    {
        $this->apiM->errors()->clearErrors();
        try {
            $typeAddReq = $this->woM->modelFactory()->request()->type()->show($xml);
            $this->woM->modelFactory()->response()->type()->show($typeAddReq->getTypeModels());
        } catch (InvalidRecordException $e) {
            // Catch invalid record contents only
            $this->apiM->responseBuilder()->endAction();
        }
    }


    /**
     * Update type
     *
     * @param \SimpleXMLElement $xml Record
     */
    public function update(\SimpleXMLElement $xml)
    {
        $this->apiM->errors()->clearErrors();
        try {
            $typeUpdateReq = $this->woM->modelFactory()->request()->type()->update($xml);
            $this->woM->modelFactory()->response()->type()->update($typeUpdateReq->getTypeModel());
        } catch (InvalidRecordException $e) {
            // Catch invalid record contents only
            $this->apiM->responseBuilder()->endAction();
        }
    }

    /**
     * Delete type
     *
     * @param \SimpleXMLElement $xml Record
     */
    public function delete(\SimpleXMLElement $xml)
    {
        $this->apiM->errors()->clearErrors();
        try {
            $typeDeleteReq = $this->woM->modelFactory()->request()->type()->delete($xml);
            $this->woM->modelFactory()->response()->type()->delete($typeDeleteReq->getTypeModel());
        } catch (InvalidRecordException $e) {
            // Catch invalid record contents only
            $this->apiM->responseBuilder()->endAction();
        }
    }
}
