<?php

use Symfony\Component\HttpKernel\Kernel;
use Symfony\Component\Config\Loader\LoaderInterface;

class AppKernel extends Kernel
{

    /**
     * Constructor.
     *
     * @param string $environment The environment
     * @param bool $debug Whether to enable debugging or not
     */
    public function __construct($environment, $debug)
    {
        date_default_timezone_set('Europe/Berlin');
        parent::__construct($environment, $debug);
    }

    public function registerBundles()
    {
        $bundles = array(
            new Symfony\Bundle\FrameworkBundle\FrameworkBundle(),
            new Symfony\Bundle\SecurityBundle\SecurityBundle(),
            new Symfony\Bundle\TwigBundle\TwigBundle(),
            new Symfony\Bundle\MonologBundle\MonologBundle(),
            new Symfony\Bundle\SwiftmailerBundle\SwiftmailerBundle(),
            new Symfony\Bundle\AsseticBundle\AsseticBundle(),
            new Doctrine\Bundle\DoctrineBundle\DoctrineBundle(),
            new Sensio\Bundle\FrameworkExtraBundle\SensioFrameworkExtraBundle(),
            new FOS\UserBundle\FOSUserBundle(),
            new JMS\SerializerBundle\JMSSerializerBundle(),
            new JMS\AopBundle\JMSAopBundle(),
            new JMS\SecurityExtraBundle\JMSSecurityExtraBundle(),
            new JMS\DiExtraBundle\JMSDiExtraBundle($this),
            new FOS\RestBundle\FOSRestBundle(),
            new Nelmio\ApiDocBundle\NelmioApiDocBundle(),
            // load LifeStyle Tools
            new LifeStyle\Tools\BackendSecurityBundle\LifeStyleToolsBackendSecurityBundle(),
            new LifeStyle\Tools\DbLogBundle\LifeStyleToolsDbLogBundle(),
            //new Sso\Tools\AWSBundle\SsoToolsAWSBundle(),@todo SF3 not working with! old guzzle
            new Sso\BackendBundle\SsoBackendBundle(),
            new Sso\RestBundle\SsoRestBundle(),
            new LifeStyle\Tools\RestAuthBundle\LifeStyleToolsRestAuthBundle(),
            new LifeStyle\Tools\RestErrorBundle\LifeStyleToolsRestErrorBundle(),
            new LifeStyle\Tools\ElkLogFormatterBundle\LifeStyleToolsElkLogFormatterBundle(),
            new LifeStyle\Tools\CachingBundle\LifeStyleToolsCachingBundle(),
        );

        if (in_array($this->getEnvironment(),
                array('dev', 'test', 'of', 'sb', 'aw', 'cb', 'mh', 'cs', 'mb', 'lsd')) || getenv('APP_DEBUG') === 'true'
        ) {
            $bundles[] = new Webfactory\Bundle\ExceptionsBundle\WebfactoryExceptionsBundle();
            $bundles[] = new Symfony\Bundle\WebProfilerBundle\WebProfilerBundle();
            $bundles[] = new Sensio\Bundle\DistributionBundle\SensioDistributionBundle();
            $bundles[] = new Sensio\Bundle\GeneratorBundle\SensioGeneratorBundle();
            $bundles[] = new Symfony\Bundle\DebugBundle\DebugBundle();
        }

        return $bundles;
    }

    public function getRootDir()
    {
        return __DIR__;
    }

    public function getCacheDir()
    {
        return dirname(__DIR__).'/var/cache/'.$this->getEnvironment();
    }

    public function registerContainerConfiguration(LoaderInterface $loader)
    {
        $loader->load($this->getRootDir().'/config/config_'.$this->getEnvironment().'.yml');
    }

    /**
     * Overwrite global log directory in aws environment
     */
    public function getLogDir()
    {
        return getenv('APP_LOGS') ? getenv('APP_LOGS') : dirname(__DIR__).'/var/logs';
    }
}
