<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\CachingBundle\Api\Configuration;

/**
 * Class Configuration
 * @package LifeStyle\Tools\CachingBundle\Api\Configuration
 */
class Configuration
{
    /**
     * @var boolean
     */
    private $cacheEnabled;

    /**
     * @var string
     */
    private $cachingEngine;

    /**
     * @var integer
     */
    private $defaultTtl;

    /**
     * @var string
     */
    private $memcacheHost;

    /**
     * @var string
     */
    private $memcachePort;


    /**
     * Manager constructor.
     * @param array $config
     */
    public function __construct($config)
    {
        $this->cacheEnabled = $config['cache_enabled'];
        $this->cachingEngine = $config['caching_engine'];
        $this->defaultTtl = $config['default_ttl'];
        $this->memcacheHost = $config['memcache_host'];
        $this->memcachePort = $config['memcache_port'];
    }

    /**
     * @return string
     */
    public function getCachingEngine()
    {
        return $this->cachingEngine;
    }

    /**
     * @return int
     */
    public function getDefaultTtl()
    {
        return $this->defaultTtl;
    }

    /**
     * @return string
     */
    public function getMemcacheHost()
    {
        return $this->memcacheHost;
    }

    /**
     * @return string
     */
    public function getMemcachePort()
    {
        return $this->memcachePort;
    }

    /**
     * @return boolean
     */
    public function isCacheEnabled()
    {
        return $this->cacheEnabled;
    }
}
