<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\CachingBundle\Api\Data\Reader;

use Symfony\Component\HttpFoundation\Request;

/**
 * Interface ReaderInterface
 * @package LifeStyle\Tools\CachingBundle\Api\Data\Reader
 */
interface ReaderInterface
{
    /**
     * Query the cache and return an object holding additional information about the cache, state and stored content,
     * if there is any
     *
     * @param Request $request
     * @return ReaderResponse|null
     */
    public function cacheRead(Request $request);

    /**
     * Query the cache and return an object holding additional information about the cache, state and stored content,
     * if there is any
     *
     * @param string $cacheKey
     * @return mixed|null
     */
    public function cacheReadByKey($cacheKey);
}
