<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\CachingBundle\Api\Data\Writer;

use Symfony\Component\HttpFoundation\Response;

/**
 * Interface WriterInterface
 * @package LifeStyle\Tools\CachingBundle\Api
 */
interface WriterInterface
{
    /**
     * Write the content of the current response into the cache using the given key and TTL
     *
     * @param Response $response
     * @param string $cacheKey
     * @param integer $cacheTTL
     */
    public function writeCache(Response $response, $cacheKey, $cacheTTL);

    /**
     * Write the content of the current response into the cache using the given key and TTL
     *
     * @param string $cacheKey
     * @param mixed $content
     * @param integer|null $cacheTTL
     */
    public function writeCacheByKey($cacheKey, $content, $cacheTTL = null);

    /**
     * Clears the cache / deletes all stored content in the cache
     *
     * Takes no parameters and does not return any results
     */
    public function clearCache();
}
