<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\CachingBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class CacheConfigController
 * @package LifeStyle\Tools\CachingBundle\Controller
 */
class CacheConfigController extends Controller
{
    /**
     * @Route("/index", name="life_style_tools_caching_index")
     * @Template()
     * @return Response
     */
    public function indexAction(Request $request)
    {
        /** @var \LifeStyle\Tools\CachingBundle\Api\Manager $cacheManager */
        $cacheManager = $this->get('life_style_tools_caching.api_manager');

        if ($request->query->get('clearCache', '0') == '1') {
            $cacheManager->data()->writer()->clearCache();
            $this->addFlash('info', 'Cache has been cleared');
        }

        $cacheConfig = $cacheManager->getConfig();

        $cachedkeys = '';
        if (extension_loaded('apc')) {
            $cachedkeys = '';
            foreach (new \APCIterator('user') as $counter) {
                $cachedkeys .= $counter['key'] . "<br />";
            }
        }

        if (extension_loaded('apcu')) {
            $cachedkeys = '';
            foreach (new \APCUIterator() as $counter) {
                if (isset($counter['type']) && $counter['type'] == 'user') {
                    $cachedkeys .= isset($counter['key']) ? $counter['key'] . '<br />' : '';
                }
            }
        }

        return [
            'cachedkeys' => $cachedkeys,
            'cacheConfig' => $cacheConfig
        ];
    }
}
