<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\CachingBundle\Controller;

use Swoox\RestBundle\EventDispatcher\Event\SearchStandardAfter;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;

/**
 * Class CacheConfigController
 * @package LifeStyle\Tools\CachingBundle\Controller
 */
class CacheController extends Controller
{
    /**
     * @return Response
     */
    public function cachedResponseAction(Request $request)
    {
        $cachedContent = '42';
        if ($request->attributes->has('_cachedContent')) {
            // get cached content that has been injected into the request by the caching event
            $cachedContent = $request->attributes->get('_cachedContent');
        }
        // build a new response with the cached content and status code....
        $response = new Response();
        if ($request->attributes->has('_statusCode')) {
            $statusCode = $request->attributes->get('_statusCode');
            $response->setStatusCode($statusCode);
        }
        $response->setContent($cachedContent);

        $eventManager = $this->container->get('cache_event_manager');

        $eventManager->dispatchCachedResponseEvent($request);
        // ....and send the cached response to the user
        return $response;
    }
}
