<?php

/**
 * Class LsCacheTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\CachingBundle\Tests\Annotations;

use LifeStyle\Tools\CachingBundle\Annotations\LsCache;
use PHPUnit_Framework_TestCase;

/**
 * Class LsCacheTest
 * @package LifeStyle\Tools\CachingBundle\Tests\Annotations
 */
class LsCacheTest extends PHPUnit_Framework_TestCase
{
    public function testLsCacheAnnotationObject()
    {
        $lsCache = new LsCache([
            'CacheTTL' => 42,
            'KeyHeader' => true
        ]);

        $this->assertEquals(42, $lsCache->getCacheTTL());
        $this->assertEquals(true, $lsCache->isKeyHeader());
        $this->assertEquals('lsCache', $lsCache->getAliasName());
        $this->assertEquals(false, $lsCache->allowArray());
    }
}
