<?php

/**
 * Class ConfigurationTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\CachingBundle\Tests\Api\Configuration;

use LifeStyle\Tools\CachingBundle\Api\Configuration\Configuration;
use PHPUnit_Framework_TestCase;

/**
 * Class ConfigurationTest
 * @package LifeStyle\Tools\CachingBundle\Tests\Api\Configuration
 */
class ConfigurationTest extends PHPUnit_Framework_TestCase
{
    public function testConfigurationObject()
    {
        $configData = [
            'cache_enabled' => true,
            'caching_engine' => 'memcache',
            'default_ttl' => 42,
            'memcache_host' => '127.0.0.1',
            'memcache_port' => '11211',
        ];

        $config = new Configuration($configData);

        $this->assertEquals('memcache', $config->getCachingEngine());
        $this->assertEquals(42, $config->getDefaultTtl());
        $this->assertEquals('127.0.0.1', $config->getMemcacheHost());
        $this->assertEquals('11211', $config->getMemcachePort());
    }
}
