<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\ElkLogFormatterBundle\Tests\DependencyInjection;

/**
 * Class DependencyInjectionTest
 * @package LifeStyle\Tools\ElkLogFormatterBundle\Tests\DependencyInjection
 */
abstract class DependencyInjectionTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @param \Symfony\Component\DependencyInjection\Definition $definition
     * @param string $expectedClass
     */
    protected function assertDICDefinitionClass($definition, $expectedClass)
    {
        $this->assertEquals($expectedClass, $definition->getClass(),
            "Expected Class of the DIC Container Service Definition is wrong.");
    }

    /**
     * @param $definition
     * @param $args
     */
    protected function assertDICConstructorArguments($definition, $args)
    {
        $this->assertEquals($args, $definition->getArguments(),
            "Expected and actual DIC Service constructor arguments of definition '" . $definition->getClass() . "' don't match.");
    }

    /**
     * @param string $pos
     * @param string $definition
     * @param string $methodName
     * @param array|null $params
     */
    protected function assertDICDefinitionMethodCallAt($pos, $definition, $methodName, array $params = null)
    {
        $calls = $definition->getMethodCalls();
        if (isset($calls[$pos][0])) {
            $this->assertEquals($methodName, $calls[$pos][0],
                "Method '" . $methodName . "' is expected to be called at position $pos.");

            if ($params !== null) {
                $this->assertEquals($params, $calls[$pos][1],
                    "Expected parameters to methods '" . $methodName . "' do not match the actual parameters.");
            }
        } else {
            $this->fail("Method '" . $methodName . "' is expected to be called at position $pos.");
        }
    }
}
