<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\ElkLogFormatterBundle\Tests\Monolog\Formatter;

use LifeStyle\Tools\ElkLogFormatterBundle\Tests\Monolog\TestCase;
use LifeStyle\Tools\ElkLogFormatterBundle\Monolog\Formatter\ElkLogFormatter;
use Monolog\Logger;

/**
 * Class TrackIdTest
 * @package LifeStyle\Tools\ElkLogFormatterBundle\Tests\Monolog\Formatter
 */
class ElkLogFormatterTest extends TestCase
{
    public function testFormatFormatter()
    {
        $formatter = new ElkLogFormatter();
        $record = array(
            'level' => Logger::ERROR,
            'level_name' => 'ERROR',
            'channel' => 'testchannel',
            'context' => [],
            'datetime' => new \DateTime("@0"),
            'extra' => ['serverData' => 'www.life-style.de'],
            'message' => 'log',
        );

        $message = $formatter->format($record);
        $this->assertTrue((boolean)strpos($message, "1970-01-01T00:00:00.000000+00:00"));
        $this->assertTrue((boolean)strpos($message, "testchannel"));
        $this->assertTrue((boolean)strpos($message, "www.life-style.de"));
        $this->assertTrue((boolean)strpos($message, "ERROR"));
        $this->assertTrue((boolean)strpos($message, gethostname()));

    }

    public function testFormBatchFormatter()
    {
        $formatter = new ElkLogFormatter();
        $record[] = array(
            'level' => Logger::ERROR,
            'level_name' => 'ERROR',
            'channel' => 'testchannel',
            'context' => [],
            'datetime' => new \DateTime("@0"),
            'extra' => ['serverData' => 'www.life-style.de'],
            'message' => 'log',
        );

        $message = $formatter->formatBatch($record);

        $this->assertTrue((boolean)strpos($message, "1970-01-01T00:00:00.000000+00:00"));
        $this->assertTrue((boolean)strpos($message, "testchannel"));
        $this->assertTrue((boolean)strpos($message, "www.life-style.de"));
        $this->assertTrue((boolean)strpos($message, "ERROR"));
        $this->assertTrue((boolean)strpos($message, gethostname()));

    }

    public function testFormatWithException()
    {
        $formatter = new ElkLogFormatter();
        $record = array(
            'level_name' => 'CRITICAL',
            'channel' => 'testchannel',
            'context' => array('exception' => new \RuntimeException('Foo')),
            'datetime' => new \DateTime("@0"),
            'extra' => ['serverData' => 'www.life-style.de'],
            'message' => 'foobar',
        );

        $message = $formatter->format($record);

        $this->assertTrue((boolean)strpos($message, "1970-01-01T00:00:00.000000+00:00"));
        $this->assertTrue((boolean)strpos($message, "testchannel"));
        $this->assertTrue((boolean)strpos($message, "www.life-style.de"));
        $this->assertTrue((boolean)strpos($message, "CRITICAL"));
        $this->assertTrue((boolean)strpos($message, gethostname()));
    }
}
