<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\RestAuthBundle\Api;

use Psr\Log\LoggerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface as Container;
use LifeStyle\Tools\RestAuthBundle\Model\Factory as ModelFactory;
use GuzzleHttp\Client;

/**
 * Class Manager
 * @package LifeStyle\Tools\RestAuthBundle\Api
 */
class Manager
{
    /**
     * @var Container
     */
    private $container;

    /**
     * @var array
     */
    private $factory = [];

    /**
     * @param Container $container
     */
    public function __construct(Container $container)
    {
        $this->container = $container;
    }

    /**
     * @return LoggerInterface
     */
    public function logger()
    {
        return $this->container->get('logger');
    }

    /**
     * @return string
     */
    public function getTrackId()
    {
        return $this->container->get('lifestyle.elk.monolog.processor.trackid')->getTrackId();
    }

    /**
     * @return ModelFactory
     */
    public function modelFactory()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new ModelFactory($this->serializer()));
    }

    /**
     * @return Client
     */
    public function client()
    {
        return new Client();
    }

    /**
     * @return \JMS\Serializer\Serializer
     */
    public function serializer()
    {
        return $this->container->get('jms_serializer');
    }

    /**
     * @return float
     */
    public function scriptSeconds()
    {
        return $this->container->get('rest_performance_listener')->getScriptSeconds();
    }

    /**
     * @return Controller
     */
    public function controller()
    {
        return new Controller($this);
    }

    /**
     *
     * @return Configuration\Index
     */
    public function configuration()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new Configuration\Index($this->container));
    }
}
