<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\RestAuthBundle\Model;

/**
 * Class Factory
 * @package LifeStyle\Tools\RestAuthBundle\Model
 */
class Factory
{
    /**
     * @var \JMS\Serializer\Serializer
     */
    private $serializer;

    /**
     * @var Request\Node\Factory
     */
    private $requestNodeFactory;

    /**
     * @param \JMS\Serializer\Serializer $serializer
     */
    public function __construct(\JMS\Serializer\Serializer $serializer)
    {
        $this->serializer = $serializer;
    }

    /**
     * @return Request
     */
    public function request()
    {
        return new Request($this->requestNodeFactory());
    }

    /**
     * @param string $response
     * @return Response
     */
    public function response($response)
    {
        return $this->serializer->deserialize($response, 'LifeStyle\Tools\RestAuthBundle\Model\Response', 'xml');
    }

    /**
     * @return Request\Node\Factory
     */
    private function requestNodeFactory()
    {
        return null !== $this->requestNodeFactory ? $this->requestNodeFactory : ($this->requestNodeFactory = new Request\Node\Factory());
    }
}
